/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.Args;
import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.ForgeEmitter;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.compat.Minecraft;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.INBTSerializable;

public class Emitter
extends SourceBase
implements IEmitter {
    private final ForgeEmitter emitter;

    public Emitter(UnitConfig config, Properties<?> props) {
        super(config, props);
        this.emitter = new ForgeEmitter(config, props.emitterProps){

            public String getClassCategory() {
                return Emitter.this.getClassCategory();
            }
        };
    }

    public boolean isActive(INBTSerializable<CompoundTag> nbtSource) {
        try {
            return super.isActive(nbtSource);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getClassCategory() {
        return IHaveConfig.getClassCategory(Emitter.class);
    }

    public String getActiveTag() {
        return this.emitter.getActiveTag();
    }

    public KeyValuePair getIdentityTag() {
        return this.emitter.getIdentityTag();
    }

    public Set<BlockState> getRelatedBlocks() {
        return this.emitter.getRelatedBlocks();
    }

    public IEmitter.Type getType() {
        return this.emitter.getType();
    }

    public BlockPos getExhaustPosition(LevelAccessor level, INBTSerializable<CompoundTag> nbtSource, BlockPos defaultPos) {
        return defaultPos;
    }

    public boolean hasSeparateRateControl() {
        return false;
    }

    public void onPostInit() {
        this.emitter.onPostInit();
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"id", (Object)this.getRelatedId()), Args.get((String)"type", (Object)this.getType()), Args.get((String)"activeTag", (Object)this.getActiveTag()), Args.get((String)"identityTag", (Object)this.getIdentityTag()), Args.get((String)"emissionMap", (Object)this.emissionMap)});
    }

    public static class Properties<T extends Properties<T>>
    extends SourceBase.Properties<T> {
        public Optional<BiFunction<UnitConfig, Properties<?>, Emitter>> factory = Optional.empty();
        public ForgeEmitter.Properties<?> emitterProps;

        protected Properties(Class<T> selfClazz, IEmitter.Type type) {
            super(selfClazz);
            this.emitterProps = ForgeEmitter.Properties.with((IEmitter.Type)type);
        }

        public static Properties<?> tile(String activeTag) {
            return (Properties)((Object)((SourceBase.Properties)((Object)Properties.with(IEmitter.Type.TILE).activeTag(activeTag))).factor(0.016f));
        }

        public static Properties<?> tile(final BooleanProperty activeProperty) {
            return Properties.tile("#hardcoded").customFactory((conf, prop) -> new Emitter((UnitConfig)conf, (Properties)((Object)prop)){

                public boolean isActive(LevelReader world, BlockPos pos) {
                    BlockState state = world.m_8055_(pos);
                    return state.m_61138_((Property)activeProperty) && (Boolean)state.m_61143_((Property)activeProperty) != false;
                }
            });
        }

        public static Properties<?> entity(String activeTag, final WorldEvents.Alignment alignment) {
            return ((Properties)((Object)((SourceBase.Properties)((Object)Properties.with(IEmitter.Type.ENTITY).activeTag(activeTag))).factor(0.016f))).customFactory((conf, prop) -> new Emitter((UnitConfig)conf, (Properties)((Object)prop)){

                @Override
                public BlockPos getExhaustPosition(LevelAccessor level, INBTSerializable<CompoundTag> nbtSource, BlockPos defaultPos) {
                    BlockPos blockPos;
                    if (nbtSource instanceof Entity) {
                        Entity entity = (Entity)nbtSource;
                        blockPos = new BlockPos(alignment.getPositionVec(entity));
                    } else {
                        blockPos = defaultPos;
                    }
                    return blockPos;
                }
            });
        }

        public static Properties<?> block() {
            return Properties.with(IEmitter.Type.BLOCK);
        }

        public static Properties<?> campfire(String id, boolean signal) {
            return ((Properties)Properties.block().id(id)).metadata("[lit=true, signal_fire=" + (signal ? "true" : "false") + "]").customFactory(Minecraft.Campfire::new);
        }

        public static Properties<?> fuel(String activeTag) {
            return Properties.fuel(activeTag, 1.0f);
        }

        public static Properties<?> fuel(String activeTag, float consumptionFactor) {
            Emissions emissions = Emissions.of();
            AdPother.getInstance().pollutants.streamAll().forEach(pollutant -> emissions.add((Pollutant<?>)((Object)pollutant), consumptionFactor));
            return ((Properties)((Object)Properties.with(IEmitter.Type.FUEL).emissions(emissions))).activeTag(activeTag);
        }

        public static Properties<?> with(IEmitter.Type type) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, type);
            return (Properties)((Object)props.comment("The amount of emissions (in blocks with light density) generated by each update of this emitter.\nThe update frequency depends on the type of the emitter (see the 'type' parameter).\nFor hardcoded emitters with type=FUEL, these values act as fuel consumption MULTIPLIERS.\nSet the value to 0 for disabling emissions from this source.\n"));
        }

        public T emitterProps(ForgeEmitter.Properties<?> emitterProps) {
            this.emitterProps = emitterProps;
            return (T)((Object)((Properties)this.self));
        }

        public T customFactory(BiFunction<UnitConfig, Properties<?>, Emitter> factory) {
            this.factory = Optional.ofNullable(factory);
            return (T)((Object)((Properties)this.self));
        }

        protected void updateId() {
            super.id(this.emitterProps.id);
        }

        public T id(UnitId id) {
            this.emitterProps.id(id);
            this.updateId();
            return (T)((Object)((Properties)this.self));
        }

        public T metadata(String metadata) {
            this.emitterProps.metadata(metadata);
            this.updateId();
            return (T)((Object)((Properties)this.self));
        }

        public T activeStateHardcoded() {
            this.emitterProps.activeStateHardcoded();
            return (T)((Object)((Properties)this.self));
        }

        public T activeTag(String activeTag) {
            this.emitterProps.activeTag(activeTag);
            return (T)((Object)((Properties)this.self));
        }

        public T identityTag(KeyValuePair identityTag) {
            this.emitterProps.identityTag(identityTag);
            return (T)((Object)((Properties)this.self));
        }

        public T fuelTag(String fuelTag) {
            this.emitterProps.fuelTag(fuelTag);
            return (T)((Object)((Properties)this.self));
        }

        public T relatedBlocks(String ... relatedBlocks) {
            this.emitterProps.relatedBlocks(relatedBlocks);
            return (T)((Object)((Properties)this.self));
        }

        public T activeProperty(String property) {
            return (T)this.metadata("[" + property + "=true]");
        }

        public T stateActive() {
            this.emitterProps.stateActive();
            this.updateId();
            return (T)((Object)((Properties)this.self));
        }

        public T stateLit() {
            this.emitterProps.stateLit();
            this.updateId();
            return (T)((Object)((Properties)this.self));
        }

        public T statePowered() {
            this.emitterProps.statePowered();
            this.updateId();
            return (T)((Object)((Properties)this.self));
        }
    }
}

