/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class Spread {
    public static final int ANY_DENSITY_DELTA = Integer.MIN_VALUE;
    public final Pollutant<?> pollutant;
    public final ServerLevel level;
    public final BlockPos sourcePos;
    @Nullable
    private BlockPos targetPos;
    private BlockState sourceState;
    @Nullable
    private BlockState targetState;
    private boolean sourceChanged = false;
    private boolean targetChanged = false;
    protected final Optional<Direction> motionFacing;

    public static Spread from(ServerLevel level, BlockPos pos, BlockState state, Pollutant<?> pollutant) {
        return new Spread(level, pos, state, pollutant);
    }

    protected Spread(ServerLevel level, BlockPos pos, BlockState state, Pollutant<?> pollutant) {
        this.pollutant = pollutant;
        this.level = level;
        this.sourcePos = pos;
        this.sourceState = state;
        this.motionFacing = pollutant.getMotionFacing((LevelAccessor)level, pos);
    }

    public Optional<BlockState> getTargetState() {
        return Optional.ofNullable(this.targetState);
    }

    public Optional<BlockPos> getTargetPos() {
        return Optional.ofNullable(this.targetPos);
    }

    protected void setTargetPos(BlockPos targetPos) {
        this.targetPos = targetPos;
    }

    protected void setTarget(BlockState target) {
        if (this.targetState != target) {
            this.targetState = target;
            this.targetChanged = true;
        }
    }

    public BlockState getSourceState() {
        return this.sourceState;
    }

    public void setSource(BlockState source) {
        if (this.sourceState != source) {
            this.sourceState = source;
            this.sourceChanged = true;
        }
    }

    public boolean sourceChanged() {
        return this.sourceChanged;
    }

    public boolean targetChanged() {
        return this.targetChanged;
    }

    public BlockPos getSourcePos() {
        return this.sourcePos;
    }

    public Spread around(int minDensityDelta) {
        if (!this.completed() && this.pollutant.canSpreadAround() && this.pollutant.getCarriedPollutionAmount(this.getSourceState()) >= minDensityDelta) {
            for (Direction facing : GameWorld.Directions.of().horizontals().shuffle().toArray()) {
                if (this.in(facing, minDensityDelta).completed()) break;
            }
        }
        return this;
    }

    public Spread in(Optional<Direction> direction, int minDensityDelta) {
        return !this.completed() && direction.isPresent() ? this.in(direction.get(), minDensityDelta) : this;
    }

    public Spread in(Direction direction, int minDensityDelta) {
        BlockPos destPos;
        if (this.completed()) {
            return this;
        }
        if ((this.pollutant.isSamePollutant(this.level.m_8055_(this.sourcePos)) || this.pollutant.canPassThrough((LevelReader)this.level, this.sourcePos, direction, direction)) && this.isInLoadedWorldBounds(destPos = this.sourcePos.m_121945_(direction))) {
            if (this.to(destPos, minDensityDelta).completed()) {
                return this;
            }
            if (this.pollutant.canPassThrough((LevelReader)this.level, destPos, direction.m_122424_(), direction)) {
                return this.to(destPos.m_121945_(direction), minDensityDelta);
            }
        }
        return this;
    }

    public Spread inMotionFacing() {
        return this.in(this.motionFacing, 0);
    }

    public Spread inDirectionForced(Direction direction) {
        return this.in(direction, Integer.MIN_VALUE);
    }

    public Spread inDirectionsForced(Supplier<GameWorld.Directions> directions) {
        if (this.completed()) {
            return this;
        }
        for (Direction direction : directions.get().toArray()) {
            if (this.completed()) {
                return this;
            }
            this.inDirectionForced(direction);
        }
        return this;
    }

    public Spread to(BlockPos targetPos, int minDensityDelta) {
        if (!this.completed() && this.isInLoadedWorldBounds(targetPos)) {
            int pollutionDelta;
            BlockState sourceState = this.getSourceState();
            BlockState targetState = this.level.m_8055_(targetPos);
            while (this.pollutant.canStateBeSpreaded(sourceState) && this.pollutant.canStateBePumped(targetState) && (pollutionDelta = this.pollutant.getCarriedPollutionAmount(sourceState) - this.pollutant.getCarriedPollutionAmount(targetState)) >= minDensityDelta) {
                sourceState = this.pollutant.getSpreadedState(sourceState);
                this.setSource(sourceState);
                this.setTargetPos(targetPos);
                targetState = this.pollutant.getPumpedState(targetState);
                this.setTarget(targetState);
            }
        }
        return this;
    }

    public Spread overLedge() {
        BlockPos ledgePos;
        if (!this.completed() && this.pollutant.canSpreadOverLedge() && this.motionFacing.isPresent() && this.isInLoadedWorldBounds(ledgePos = this.sourcePos.m_121945_(this.motionFacing.get()))) {
            BlockPos targetPos;
            Direction facing;
            BlockPos checkPos;
            int minDelta = this.pollutant.isSamePollutant(this.level.m_8055_(ledgePos)) ? 0 : -1;
            boolean sourceIsSamePollutant = this.pollutant.isSamePollutant(this.level.m_8055_(this.sourcePos));
            Direction[] directionArray = GameWorld.Directions.of().horizontals().shuffle().toArray();
            int n = directionArray.length;
            for (int i = 0; !(i >= n || this.isInLoadedWorldBounds(checkPos = this.sourcePos.m_121945_(facing = directionArray[i])) && (sourceIsSamePollutant || this.pollutant.canPassThrough((LevelReader)this.level, this.sourcePos, facing, facing)) && this.pollutant.canPassThrough((LevelReader)this.level, checkPos, facing.m_122424_(), this.motionFacing.get()) && this.to(targetPos = ledgePos.m_121945_(facing), minDelta).completed()); ++i) {
            }
        }
        return this;
    }

    protected boolean isInLoadedWorldBounds(BlockPos pos) {
        return this.level.m_46739_(pos) && this.level.m_46749_(pos);
    }

    public boolean completed() {
        return this.sourceChanged() && this.targetChanged();
    }

    protected boolean apply(BlockPos pos, BlockState state) {
        if (this.level.m_46597_(pos, state)) {
            if (this.pollutant.isSamePollutant(state)) {
                this.pollutant.scheduleUpdate((Level)this.level, pos);
            }
            return true;
        }
        return false;
    }

    public boolean applyTarget() {
        return this.completed() && this.getTargetPos().isPresent() && this.getTargetState().isPresent() && this.apply(this.getTargetPos().get(), this.getTargetState().get());
    }

    public boolean applySource() {
        return this.completed() && this.apply(this.getSourcePos(), this.getSourceState());
    }

    public boolean apply() {
        return this.applyTarget() && this.applySource();
    }
}

