/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.init.Sources;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.PlayerBurning;
import com.endertech.minecraft.mods.adpother.sources.PlayerDying;
import com.endertech.minecraft.mods.adpother.sources.PlayerEating;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerEvents {
    private static final GameTime PLAYER_UPDATE_INTERVAL = GameTime.quaterSecond();
    private static final GameTime IGNITION_FROM_TORCH_CHECK_INTERVAL = GameTime.second();

    static Optional<ServerPlayer> getServerPlayer(LivingEvent event) {
        Optional<ServerPlayer> optional;
        if (event.isCanceled()) {
            return Optional.empty();
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            optional = Optional.of(player);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    private static boolean affectedByPollution(Player player) {
        EntityPollution pollution = WorldData.getEntityPollution((Entity)player);
        return pollution.getPollutants().anyMatch(pollutant -> pollution.isHeadInPollutant((Pollutant<?>)((Object)pollutant)) || pollutant.canAffectEntity((Entity)player, AbstractPollutionImpacts.ImpactType.AIR, pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant))));
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            BlockPos pos;
            BlockState state;
            ServerLevel level2 = (ServerLevel)level;
            if (event.getUseBlock() != Event.Result.DENY && (state = level2.m_8055_(pos = event.getPos())).m_60734_() == Blocks.f_50145_) {
                PlayerEvents.getServerPlayer((LivingEvent)event).filter(pl -> pl.m_36391_(false)).ifPresent(pl -> ((PlayerEating)((Object)((Object)AdPother.getInstance().sources.playerEating.get()))).emitFrom(pl, 2.0f));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onFinishUsing(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        if (stack.m_41780_() == UseAnim.EAT) {
            PlayerEvents.getServerPlayer((LivingEvent)event).ifPresent(player -> ((PlayerEating)((Object)((Object)AdPother.getInstance().sources.playerEating.get()))).emitFrom((Player)player, stack));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDeath(LivingDeathEvent event) {
        Sources sources = AdPother.getInstance().sources;
        if (event.getSource().m_19384_()) {
            PlayerEvents.getServerPlayer((LivingEvent)event).ifPresent(player -> ((PlayerBurning)((Object)((Object)sources.playerBurning.get()))).emitFrom(player, 1.0f));
        } else {
            PlayerEvents.getServerPlayer((LivingEvent)event).ifPresent(player -> ((PlayerDying)((Object)((Object)sources.playerDying.get()))).emitFrom(player, 1.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onInventoryTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        if (player == null || stack.m_41619_()) {
            return;
        }
        Respirators.Respirator respirator = AdPother.getInstance().respirators.get(stack).orElse(null);
        if (respirator != null && player.f_19853_ != null) {
            respirator.appendHoverText(stack, player.f_19853_, event.getToolTip(), event.getFlags());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerBreaksBlock(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getPlayer().m_7500_()) {
            return;
        }
        Level level = player.f_19853_;
        if (level == null || !GameWorld.isServerSide((LevelReader)level)) {
            return;
        }
        int silkLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_());
        if (silkLevel > 0) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        WorldEvents.onBlockBroken(level, pos, state);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = player2.f_19853_;
            if (player instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)player;
                if (IGNITION_FROM_TORCH_CHECK_INTERVAL.pastIn((Level)level)) {
                    GasExplosion.fromHeldTorch((Player)player2).tryExplode();
                }
                if (!PLAYER_UPDATE_INTERVAL.pastIn((Level)level)) {
                    return;
                }
                EntityPollution pollution = WorldData.getEntityPollution((Entity)player2);
                pollution.update();
                boolean explosionRisk = GasExplosion.in((Level)level).positions(GasExplosion.getIgnitablePositionsAround((Player)player2, EnumSet.allOf(InteractionHand.class))).tryTrigger();
                pollution.setExplosionRisk(explosionRisk);
                new EntityPollution.NetMsg(pollution).sendToAllAround((ServerLevelAccessor)level, player2.m_20183_(), 64);
            }
        }
    }
}

