/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.entities;

import com.endertech.common.FloatBounds;
import com.endertech.common.IBounds;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.AABBHelper;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.FilterFrame;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class PurifiedAir
extends ForgeEntity {
    protected static final EntityDataAccessor<Boolean> FADING = SynchedEntityData.m_135353_(PurifiedAir.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected final GameTime checkSourceInterval = GameTime.second();
    protected Block pollutant;
    protected BlockPos filterPos;
    protected Block filter;
    protected Percentage concentration;

    public PurifiedAir(EntityType<?> type, Level world) {
        super(type, world);
    }

    public PurifiedAir(Level world, BlockPos pos, Pollutant<?> pollutant, BlockPos filterPos) {
        this((EntityType)AdPother.getInstance().entities.purifiedAir.get(), world);
        this.pollutant = pollutant;
        this.filterPos = filterPos;
        this.filter = world.m_8055_(filterPos).m_60734_();
        this.concentration = Percentage.ZERO;
        Vect3d centeredPos = PurifiedAir.getCenteredPosTo((BlockPos)pos);
        this.setAllPositions(centeredPos);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(FADING, (Object)false);
    }

    public static List<PurifiedAir> getAllAt(Level world, BlockPos pos) {
        AABB aabb = AABBHelper.BLOCK.m_82338_(pos);
        return world.m_45976_(PurifiedAir.class, aabb);
    }

    public Optional<Pollutant<?>> getPollutant() {
        return this.pollutant instanceof Pollutant ? Optional.of((Pollutant)this.pollutant) : Optional.empty();
    }

    public boolean m_6097_() {
        return false;
    }

    public void m_8119_() {
        if (this.isServerSide()) {
            this.onServerTick();
        } else {
            this.onClientTick();
        }
    }

    protected void onClientTick() {
    }

    protected void onServerTick() {
        if (!this.getPollutant().isPresent() || !this.getFilter().isPresent()) {
            this.m_146870_();
            return;
        }
        boolean fading = (Boolean)this.m_20088_().m_135370_(FADING);
        FloatBounds percentage = GameBounds.PERCENTAGE.getFloatBounds();
        int signum = fading ? -1 : 1;
        float speed = 0.2f;
        float value = percentage.enclose(Float.valueOf(this.concentration.getValue() + (float)signum * speed)).floatValue();
        this.concentration = Percentage.value((float)value);
        if (fading && this.concentration.getValue() <= percentage.getMin().floatValue()) {
            this.m_146870_();
            return;
        }
        if (!this.checkSourceInterval.pastIn(this.f_19853_)) {
            return;
        }
        boolean renewable = this.hasFilterProperMaterial() && this.isPurifierActive();
        this.m_20088_().m_135381_(FADING, (Object)(!renewable ? 1 : 0));
    }

    protected boolean hasFilterProperMaterial() {
        return this.getFilter().flatMap(filter -> filter.getTile((BlockGetter)this.f_19853_, this.filterPos)).map(tile -> tile.getTargetPollutants().contains(this.pollutant)).orElse(false);
    }

    protected boolean isPurifierActive() {
        return this.getPurifier().map(purifier -> purifier.getOutputPos((LevelReader)this.f_19853_, this.filterPos).equals((Object)this.m_20183_()) && purifier.isActive((LevelReader)this.f_19853_, this.filterPos)).orElse(false);
    }

    public Percentage getConcentrationAt(Vec3 position) {
        FilterFrame.AirPurifier purifier = this.getPurifier().orElse(null);
        if (purifier == null) {
            return Percentage.ZERO;
        }
        double distance = this.m_20182_().m_82554_(position);
        if (distance <= (double)purifier.effectiveRadius) {
            return this.concentration;
        }
        if (distance > (double)purifier.maximumRadius) {
            return Percentage.ZERO;
        }
        float value = ((Float)FloatBounds.between((Float)Float.valueOf(purifier.effectiveRadius), (Float)Float.valueOf(purifier.maximumRadius)).interpolateTo((IBounds)FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(this.concentration.getValue()))).backward((Number)Float.valueOf((float)distance))).floatValue();
        return Percentage.value((float)value);
    }

    public void startFading() {
        this.m_20088_().m_135381_(FADING, (Object)true);
    }

    public Optional<FilterFrame.AirPurifier> getPurifier() {
        return this.getFilter().map(FilterFrame::getAirPurifier);
    }

    public Optional<FilterFrame> getFilter() {
        return this.filter instanceof FilterFrame ? Optional.of((FilterFrame)this.filter) : Optional.empty();
    }

    protected void m_7378_(CompoundTag compound) {
        this.pollutant = Optional.of(compound.m_128461_("pollutant")).map(ResourceLocation::m_135820_).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0)).orElse(Blocks.f_50016_);
        this.filter = Optional.of(compound.m_128461_("filter")).map(ResourceLocation::m_135820_).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0)).orElse(Blocks.f_50016_);
        this.filterPos = BlockPos.m_122022_((long)compound.m_128454_("filterPos"));
        this.concentration = Percentage.value((float)compound.m_128457_("concentration"));
        this.f_19804_.m_135381_(FADING, (Object)compound.m_128471_("fading"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("pollutant", ForgeBlock.getRegistryName((Block)this.pollutant).toString());
        compound.m_128359_("filter", ForgeBlock.getRegistryName((Block)this.filter).toString());
        compound.m_128356_("filterPos", this.filterPos.m_121878_());
        compound.m_128350_("concentration", this.concentration.getValue());
        compound.m_128379_("fading", ((Boolean)this.f_19804_.m_135370_(FADING)).booleanValue());
    }
}

