/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.entities;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.AbstractCarrier;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;

public class GasEntity
extends AbstractCarrier {
    public static final float FULL_RENDER_SCALE = 0.99f;
    public static ForgeConfigSpec.ConfigValue<Integer> maxGasEntitiesInChunk;
    static final long maxExistence;
    protected final GameTime stuckUpdateInterval = GameTime.seconds((int)3);
    protected static final EntityDataAccessor<Boolean> STUCK;
    protected float renderScaleXZ = 0.0f;

    public GasEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public GasEntity(Level world, BlockPos pos, BlockState carriedState) {
        super((EntityType)AdPother.getInstance().entities.gas.get(), world, pos, carriedState);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STUCK, (Object)false);
    }

    public boolean isStuck() {
        return (Boolean)this.m_20088_().m_135370_(STUCK);
    }

    public void setStuck(boolean value) {
        this.m_20088_().m_135381_(STUCK, (Object)value);
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean fasterThan(GasEntity otherGas) {
        float otherGasVelocity;
        float thisGasVelocity = this.getPollutant().map(p -> Float.valueOf(p.getMotionVelocityIn(BiomeId.from((LevelAccessor)this.f_19853_, (BlockPos)this.m_20183_())))).orElse(Float.valueOf(0.0f)).floatValue();
        return thisGasVelocity > (otherGasVelocity = otherGas.getPollutant().map(p -> Float.valueOf(p.getMotionVelocityIn(BiomeId.from((LevelAccessor)otherGas.f_19853_, (BlockPos)otherGas.m_20183_())))).orElse(Float.valueOf(0.0f)).floatValue());
    }

    public void m_6075_() {
        boolean alignedToBlock;
        GasEntity otherGas;
        Object nextBlock;
        BlockState newState;
        Level pos;
        ServerLevel serverLevel;
        Level level;
        if (!this.m_6084_()) {
            return;
        }
        if (this.isServerSide() && this.isStuck() && !this.stuckUpdateInterval.pastIn(this.f_19853_)) {
            return;
        }
        if (this.isClientSide()) {
            this.updateRenderSizeXZ();
        }
        if (this.isClientSide() && this.isStuck()) {
            return;
        }
        Level level2 = this.f_19853_;
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel2 = (ServerLevel)level2;
            serverLevel2.m_8886_();
            if (!serverLevel2.m_143340_(this.m_20183_())) {
                return;
            }
        }
        BlockState carriedState = this.getCarriedBlockState().orElse(null);
        Pollutant pollutant = this.getPollutant().orElse(null);
        if (carriedState == null || pollutant == null || pollutant == Blocks.f_50016_ || pollutant.getCarriedPollutionAmount(carriedState) <= 0 || this.f_19853_.m_151570_(this.m_20183_())) {
            if (this.isServerSide()) {
                this.m_146870_();
            }
            return;
        }
        if (this.isStuck() && (level = this.f_19853_) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            pos = this.m_20183_();
            if ((long)this.f_19797_ > maxExistence && !GameWorld.SmokeContainers.isChimney((LevelReader)serverLevel, (BlockPos)pos) || !serverLevel.m_6425_((BlockPos)pos).m_76178_()) {
                this.dropAsItem(0.0f);
                return;
            }
        }
        if ((pos = this.f_19853_) instanceof ServerLevel && (newState = pollutant.tryAffectBlockAt(serverLevel = (ServerLevel)pos, (BlockPos)(pos = GasEntity.getCenterPosition((Entity)this).toBlockPos()), Optional.empty(), AbstractPollutionImpacts.ImpactType.CONTACT, carriedState)) != carriedState) {
            this.setCarriedBlockState(Optional.of(newState));
            return;
        }
        Optional<Direction> motionFacing = pollutant.getMotionFacing((LevelAccessor)this.f_19853_, this.m_20183_());
        double motionY = 0.0;
        if (motionFacing.isPresent()) {
            Optional airflow;
            BlockPos pos2 = this.m_20183_();
            float velocity = pollutant.getMotionVelocityIn(BiomeId.from((LevelAccessor)this.f_19853_, (BlockPos)pos2));
            if (motionFacing.get() == Direction.DOWN) {
                velocity = -velocity;
            }
            if ((airflow = GameWorld.SmokeContainers.getPumpedChimneyAirflow((LevelReader)this.f_19853_, (BlockPos)pos2)).isPresent()) {
                velocity = FloatBounds.between((Float)((Float)airflow.get()), (Float)Float.valueOf(1.0f)).enclose(Float.valueOf(Math.abs(velocity + ((Float)airflow.get()).floatValue()))).floatValue();
            }
            motionY = velocity;
        }
        this.m_20334_(0.0, motionY, 0.0);
        boolean canPassThrough = false;
        double motionY2 = this.m_20184_().f_82480_;
        if (motionY2 != 0.0) {
            AABB nextBB = this.getBB(this.getNextPosition());
            BlockPos currentBlock = this.m_20183_();
            if (currentBlock.equals(nextBlock = new BlockPos(this.m_20185_(), motionY2 < 0.0 ? nextBB.f_82289_ : nextBB.f_82292_, this.m_20189_()))) {
                canPassThrough = true;
            } else {
                Optional airflow;
                Direction facing;
                Direction direction = facing = motionY2 < 0.0 ? Direction.DOWN : Direction.UP;
                if (pollutant.canPassThrough((LevelReader)this.f_19853_, currentBlock, facing, facing) && pollutant.canPassThrough((LevelReader)this.f_19853_, (BlockPos)nextBlock, facing.m_122424_(), facing.m_122424_()) && ((airflow = GameWorld.SmokeContainers.getPumpedChimneyAirflow((LevelReader)this.f_19853_, (BlockPos)nextBlock)).isEmpty() || CommonMath.sameSign((double)((Float)airflow.get()).floatValue(), (double)this.m_20184_().m_7098_()))) {
                    canPassThrough = true;
                }
            }
        }
        boolean entityCollided = false;
        if (canPassThrough) {
            this.setStuck(false);
            boolean blockSize = true;
            double motionSign = Math.signum(this.m_20184_().f_82480_);
            nextBlock = this.getCollidedWithIfMove(GasEntity.class, GasEntity.getMotion((Entity)this), Entity::m_6084_).iterator();
            if (nextBlock.hasNext()) {
                otherGas = (GasEntity)((Object)nextBlock.next());
                if (this.isServerSide() && this.spreadTo(otherGas, 0) && this.spend()) {
                    return;
                }
                if (this.isServerSide() && !this.carriesSameBlock(otherGas.getPollutant()) && this.fasterThan(otherGas)) {
                    Optional otherState = otherGas.getCarriedBlockState();
                    otherGas.setCarriedBlockState(this.getCarriedBlockState());
                    this.setCarriedBlockState(otherState);
                    return;
                }
                double alignedY = otherGas.m_20186_() - motionSign * 1.0;
                this.f_19855_ = this.m_20186_();
                this.m_6034_(this.m_20185_(), alignedY, this.m_20189_());
                canPassThrough = false;
                entityCollided = true;
                this.m_6853_(true);
            }
        }
        if (canPassThrough) {
            this.m_6853_(false);
            this.move();
            return;
        }
        this.m_6853_(true);
        long alignedY = Math.round(this.m_20186_());
        if (!entityCollided) {
            this.m_6034_(this.m_20185_(), alignedY, this.m_20189_());
        }
        boolean bl = alignedToBlock = this.m_20186_() == (double)alignedY;
        if (alignedToBlock) {
            this.setStuck(true);
        }
        if (alignedToBlock && (otherGas = this.f_19853_) instanceof ServerLevel) {
            List pumps;
            int count;
            ServerLevel serverLevel3 = (ServerLevel)otherGas;
            if (GameWorld.SmokeContainers.isVent((LevelReader)serverLevel3, (BlockPos)this.m_20183_()) && (count = GameWorld.SmokeContainers.pumpPollutionThrough((List)(pumps = GameWorld.SmokeContainers.getClosestActiveExhaustPumps((LevelAccessor)serverLevel3, (BlockPos)this.m_20183_())), (LevelAccessor)serverLevel3, (IPollutant)pollutant, (int)this.getPollutionAmount())) > 0) {
                while (count > 0 && this.spend()) {
                    --count;
                }
                return;
            }
            Spread spread = pollutant.createSpread(serverLevel3, this.m_20183_(), carriedState).overLedge().to(this.m_20183_(), Integer.MIN_VALUE).around(Integer.MIN_VALUE);
            if (spread.applyTarget()) {
                this.setCarriedBlockState(Optional.of(spread.getSourceState()));
            }
        }
    }

    protected boolean dropAsItem(float offsetY) {
        ItemStack stack;
        Pollutant pollutant = this.getPollutant().orElse(null);
        if (pollutant != null && this.m_5552_(stack = new ItemStack((ItemLike)pollutant, this.getPollutionAmount()), offsetY) != null) {
            this.m_146870_();
            return true;
        }
        return false;
    }

    public float getRenderOffset(Direction.Axis axis) {
        float offset = (1.0f - this.getRenderScale(axis)) / 2.0f;
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.Y -> offset;
            case Direction.Axis.X, Direction.Axis.Z -> offset - 0.5f;
        };
    }

    public float getRenderScale(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.Y -> 0.99f;
            case Direction.Axis.X, Direction.Axis.Z -> this.renderScaleXZ;
        };
    }

    protected int getChimneyWallThickness(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        VoxelShape chimneyShape = state.m_60812_(level, pos);
        for (int thickness = 3; thickness <= 6; ++thickness) {
            VoxelShape holeShape = Block.m_49796_((double)thickness, (double)0.0, (double)thickness, (double)(16 - thickness), (double)16.0, (double)(16 - thickness));
            if (!Shapes.m_83148_((VoxelShape)chimneyShape, (VoxelShape)holeShape, (BooleanOp)BooleanOp.f_82689_).m_83281_()) continue;
            return thickness;
        }
        return 7;
    }

    public void updateRenderSizeXZ() {
        float offsetY = this.getRenderOffset(Direction.Axis.Y);
        float size = 0.99f;
        for (double y : new double[]{this.m_20191_().f_82289_ + (double)offsetY, this.m_20191_().f_82292_ - (double)offsetY}) {
            BlockPos pos = new BlockPos(this.m_20185_(), y, this.m_20189_());
            if (!GameWorld.SmokeContainers.isChimney((LevelReader)this.f_19853_, (BlockPos)pos)) continue;
            int thickness = this.getChimneyWallThickness((BlockGetter)this.f_19853_, pos);
            size = Math.min(size, 0.99f - (float)(2 * thickness) / 16.0f);
        }
        this.renderScaleXZ = size;
    }

    static {
        maxExistence = GameTime.inServerTicks((CommonTime.Interval)CommonTime.Interval.minutes((double)5.0));
        STUCK = SynchedEntityData.m_135353_(GasEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

