/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.Lazy;

public class McwWindows {
    protected static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final int MAX_DISTANCE = 8;
    protected static final int MAX_HEIGHT = 4;
    private static final Lazy<Optional<McwWindows>> INSTANCE = AbstractForgeMod.singletonInstance((String)"mcwwindows", McwWindows.class);
    private final Class<?> WindowBarredClass = Class.forName("com.mcwwindows.kikoz.objects.WindowBarred");
    private final Method isOpenMethod = this.WindowBarredClass.getMethod("isOpen", BlockState.class);

    public static Optional<McwWindows> getInstance() {
        return (Optional)INSTANCE.get();
    }

    private McwWindows() throws ClassNotFoundException, NoSuchMethodException {
    }

    protected boolean isOpenWindow(BlockState state) {
        Block block = state.m_60734_();
        if (this.WindowBarredClass.isInstance(block)) {
            try {
                return (Boolean)this.isOpenMethod.invoke((Object)block, state);
            }
            catch (Exception e) {
                this.logError(e.toString());
            }
        }
        return false;
    }

    protected boolean pushGas(ServerLevel level, BlockPos windowPos, Direction outputDirection) {
        BlockPos pos;
        for (int distance = 1; distance <= 4 && GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)(pos = windowPos.m_5484_(outputDirection, distance))); ++distance) {
            AbstractGas gas;
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof AbstractGas && (gas = (AbstractGas)block).createSpread(level, pos, state).inDirectionForced(outputDirection).inMotionFacing().overLedge().apply()) {
                return true;
            }
            if (state.m_60783_((BlockGetter)level, pos, outputDirection) || state.m_60783_((BlockGetter)level, pos, outputDirection.m_122424_())) break;
        }
        return false;
    }

    public boolean tryDrawGasOut(ServerLevel level, BlockPos windowPos, BlockState windowState, boolean isWindowClosing) {
        WorldBounds searchBounds;
        BlockPos inputPos;
        BlockPos gasPos;
        Direction outputDirection;
        if (!this.isOpenWindow(windowState)) {
            return false;
        }
        if (!windowState.m_61138_((Property)FACING)) {
            return false;
        }
        Direction windowFacing = (Direction)windowState.m_61143_((Property)FACING);
        Direction direction = outputDirection = isWindowClosing ? windowFacing.m_122424_() : (Direction)this.getOutputDirection(level, windowPos, windowFacing).orElse(null);
        if (outputDirection == null) {
            return false;
        }
        BlockPos outputPos = windowPos.m_121945_(outputDirection);
        if (!this.isValidOutput(level, outputPos)) {
            return false;
        }
        if (isWindowClosing) {
            this.pushGas(level, windowPos, outputDirection);
        }
        if ((gasPos = (BlockPos)this.findGas(level, inputPos = windowPos.m_121945_(outputDirection.m_122424_()), searchBounds = this.getSearchBounds(inputPos, outputDirection)).orElse(null)) == null) {
            return false;
        }
        Block block = level.m_8055_(gasPos).m_60734_();
        if (block instanceof AbstractGas) {
            AbstractGas gas = (AbstractGas)block;
            return gas.pump((LevelAccessor)level, outputPos) && gas.spend((LevelAccessor)level, gasPos);
        }
        return false;
    }

    protected void logError(String msg) {
        ForgeEndertech.debugMsg((String)("McwWindows: " + msg));
    }

    protected boolean isValidOutput(ServerLevel level, BlockPos pos) {
        if (GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)pos)) {
            BlockState state = level.m_8055_(pos);
            return state.m_60795_() || state.m_60734_() instanceof AbstractGas;
        }
        return false;
    }

    protected Optional<Direction> getOutputDirection(ServerLevel level, BlockPos windowPos, Direction windowFacing) {
        for (Direction direction : new Direction[]{windowFacing, windowFacing.m_122424_()}) {
            BlockState state;
            BlockPos pos;
            for (int distance = 1; distance <= 8 && GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)(pos = windowPos.m_5484_(direction, distance))) && !(state = level.m_8055_(pos)).m_60783_((BlockGetter)level, pos, direction.m_122424_()) && !state.m_60783_((BlockGetter)level, pos, direction); ++distance) {
                if (!level.m_45527_(pos)) continue;
                return Optional.of(direction);
            }
        }
        return Optional.empty();
    }

    protected IntBounds getAxisBounds(Direction.Axis axis, BlockPos inputPos, Direction outputDirection) {
        return outputDirection.m_122434_() == axis ? IntBounds.between((Integer)inputPos.m_123304_(axis), (Integer)inputPos.m_5484_(outputDirection.m_122424_(), 8).m_123304_(axis)) : IntBounds.of((Integer)inputPos.m_123304_(axis)).extend(Integer.valueOf(4));
    }

    protected WorldBounds getSearchBounds(BlockPos inputPos, Direction outputDirection) {
        IntBounds y = IntBounds.between((Integer)inputPos.m_123342_(), (Integer)(inputPos.m_123342_() + 4));
        IntBounds x = this.getAxisBounds(Direction.Axis.X, inputPos, outputDirection);
        IntBounds z = this.getAxisBounds(Direction.Axis.Z, inputPos, outputDirection);
        return WorldBounds.from((IntBounds)x, (IntBounds)y, (IntBounds)z);
    }

    protected Optional<BlockPos> findGas(final ServerLevel level, BlockPos startPos, final WorldBounds searchBounds) {
        WorldSearch.BlockChain chain = new WorldSearch.BlockChain((LevelAccessor)level, startPos, 256){

            protected Collection<Direction> getDirections() {
                return GameWorld.Directions.of().up().horizontals().shuffle().toList();
            }

            protected boolean isOutsideBounds(BlockPos pos) {
                if (!searchBounds.encloses(pos)) {
                    return true;
                }
                return super.isOutsideBounds(pos);
            }

            protected boolean isValidPath(BlockPos pos) {
                if (level.m_46859_(pos)) {
                    return true;
                }
                if (this.lastUsedDirection == null) {
                    return true;
                }
                BlockPos last = pos.m_121945_(this.lastUsedDirection.m_122424_());
                return !level.m_8055_(last).m_60783_((BlockGetter)level, last, this.lastUsedDirection) && !level.m_8055_(pos).m_60783_((BlockGetter)level, pos, this.lastUsedDirection.m_122424_());
            }

            protected boolean isValidBlock(BlockPos pos) {
                return level.m_8055_(pos).m_60734_() instanceof AbstractGas;
            }

            protected boolean onValidFound(BlockPos pos) {
                return false;
            }
        };
        chain.build();
        return chain.getFound().stream().findFirst();
    }
}

