/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator;

import com.mojang.math.Vector3f;
import com.teamabnormals.blueprint.core.endimator.Endimation;
import com.teamabnormals.blueprint.core.endimator.EndimationKeyframe;
import com.teamabnormals.blueprint.core.endimator.Endimator;
import java.util.function.Function;

public enum KeyframeType {
    POSITION(Endimation.PartKeyframes::getPosFrames, (pose, x, y, z, weight) -> pose.addPos(x * weight, y * weight, z * weight)),
    ROTATION(Endimation.PartKeyframes::getRotationFrames, (pose, x, y, z, weight) -> pose.addRotation(x * weight * ((float)Math.PI / 180), y * weight * ((float)Math.PI / 180), z * weight * ((float)Math.PI / 180))),
    OFFSET(Endimation.PartKeyframes::getOffsetFrames, (pose, x, y, z, weight) -> pose.addOffset(x * weight, y * weight, z * weight)),
    SCALE(Endimation.PartKeyframes::getScaleFrames, (pose, x, y, z, weight) -> pose.addScale(weight * (x - 1.0f), weight * (y - 1.0f), weight * (z - 1.0f)));

    private final Function<Endimation.PartKeyframes, EndimationKeyframe[]> getter;
    private final Procedure procedure;

    private KeyframeType(Function<Endimation.PartKeyframes, EndimationKeyframe[]> getter, Procedure procedure) {
        this.getter = getter;
        this.procedure = procedure;
    }

    public EndimationKeyframe[] getFrames(Endimation.PartKeyframes partKeyframes) {
        return this.getter.apply(partKeyframes);
    }

    public void apply(Endimator.PosedPart pose, Vector3f vector3f, float weight) {
        this.procedure.apply(pose, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), weight);
    }

    @FunctionalInterface
    static interface Procedure {
        public void apply(Endimator.PosedPart var1, float var2, float var3, float var4, float var5);
    }
}

