/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.NumberConfig;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class LongConfig
extends NumberConfig<Long> {
    public LongConfig(long mn, long mx) {
        super(mn, mx);
    }

    @Override
    public void addInfo(TooltipList list) {
        super.addInfo(list);
        if ((Long)this.min != Long.MIN_VALUE) {
            list.add(LongConfig.info("Min", this.formatValue((Long)this.min)));
        }
        if ((Long)this.max != Long.MAX_VALUE) {
            list.add(LongConfig.info("Max", this.formatValue((Long)this.max)));
        }
    }

    @Override
    public boolean parse(@Nullable Consumer<Long> callback, String string) {
        try {
            long v = Long.decode(string);
            if (v >= (Long)this.min && v <= (Long)this.max) {
                if (callback != null) {
                    callback.accept(v);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected String formatValue(Long v) {
        return String.format("%,d", v);
    }
}

