/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures.height;

import com.stal111.valhelsia_structures.common.world.structures.height.BelowSurfaceHeightProvider;
import com.stal111.valhelsia_structures.common.world.structures.height.DeepSpawnerRoomHeightProvider;
import com.stal111.valhelsia_structures.common.world.structures.height.DefaultHeightProvider;
import com.stal111.valhelsia_structures.common.world.structures.height.DeferredCodec;
import com.stal111.valhelsia_structures.common.world.structures.height.SpawnerRoomHeightProvider;
import com.stal111.valhelsia_structures.common.world.structures.height.StructureHeightProviderType;
import com.stal111.valhelsia_structures.common.world.structures.height.SurfaceHeightProvider;
import com.stal111.valhelsia_structures.common.world.structures.height.UniformHeightProvider;
import com.stal111.valhelsia_structures.core.ValhelsiaStructures;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;

public abstract class StructureHeightProvider {
    public static final DeferredCodec<StructureHeightProvider> CODEC = new DeferredCodec(() -> ValhelsiaStructures.STRUCTURE_HEIGHT_PROVIDER_TYPES.get().getCodec().dispatch(StructureHeightProvider::getType, StructureHeightProviderType::codec));

    public abstract OptionalInt sample(BlockPos var1, Structure.GenerationContext var2, Heightmap.Types var3);

    public abstract int minY(BlockPos var1, Structure.GenerationContext var2, Heightmap.Types var3);

    public abstract int maxY(BlockPos var1, Structure.GenerationContext var2, Heightmap.Types var3);

    public abstract StructureHeightProviderType<?> getType();

    protected WorldGenerationContext getWorldGenerationContext(Structure.GenerationContext context) {
        return new WorldGenerationContext(context.f_226622_(), context.f_226629_());
    }

    public static DefaultHeightProvider of(HeightProvider provider) {
        return new DefaultHeightProvider(provider);
    }

    public static BelowSurfaceHeightProvider belowSurface(VerticalAnchor verticalAnchor) {
        return new BelowSurfaceHeightProvider(verticalAnchor);
    }

    public static DefaultHeightProvider constant(VerticalAnchor verticalAnchor) {
        return StructureHeightProvider.of((HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)verticalAnchor));
    }

    public static UniformHeightProvider uniform(VerticalAnchor minInclusive, VerticalAnchor maxInclusive) {
        return UniformHeightProvider.of(minInclusive, maxInclusive);
    }

    public static SpawnerRoomHeightProvider spawnerRoom(VerticalAnchor minInclusive) {
        return new SpawnerRoomHeightProvider(minInclusive);
    }

    public static DeepSpawnerRoomHeightProvider deepSpawnerRoom(VerticalAnchor minInclusive, VerticalAnchor maxInclusive) {
        return new DeepSpawnerRoomHeightProvider(minInclusive, maxInclusive);
    }

    public static SurfaceHeightProvider surfaceBetween(VerticalAnchor minInclusive, VerticalAnchor maxInclusive) {
        return new SurfaceHeightProvider(minInclusive, maxInclusive);
    }
}

