/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.valhelsia_structures.common.world.structures.ValhelsiaStructureSettings;
import com.stal111.valhelsia_structures.common.world.structures.height.StructureHeightProvider;
import com.stal111.valhelsia_structures.core.init.world.ModStructureTypes;
import com.stal111.valhelsia_structures.core.init.world.ModStructures;
import com.stal111.valhelsia_structures.utils.StructureUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.common.world.structure.SimpleValhelsiaStructure;

public class ValhelsiaJigsawStructure
extends SimpleValhelsiaStructure {
    public static final Codec<ValhelsiaJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValhelsiaJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)Codec.STRING.fieldOf("name").forGetter(SimpleValhelsiaStructure::getName), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(structure -> structure.maxDepth), (App)StructureHeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.BOOL.fieldOf("individual_terrain_adjustment").forGetter(structure -> structure.individualTerrainAdjustment), (App)Codec.list((Codec)StructureSet.f_210002_).fieldOf("requires_distance_to").forGetter(structure -> structure.requiresDistanceTo)).apply((Applicative)instance, ValhelsiaJigsawStructure::new)).flatXmap(ValhelsiaJigsawStructure.verifyRange(), ValhelsiaJigsawStructure.verifyRange()).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final StructureHeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final boolean individualTerrainAdjustment;
    private final List<Holder<StructureSet>> requiresDistanceTo;

    public ValhelsiaJigsawStructure(Structure.StructureSettings settings, String name, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, StructureHeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, boolean individualTerrainAdjustment, List<Holder<StructureSet>> requiresDistanceTo) {
        super(settings, name);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.individualTerrainAdjustment = individualTerrainAdjustment;
        this.requiresDistanceTo = requiresDistanceTo;
    }

    public ValhelsiaJigsawStructure(Structure.StructureSettings p_227620_, String name, Holder<StructureTemplatePool> startPool, int p_227622_, StructureHeightProvider p_227623_, Heightmap.Types p_227625_, boolean individualTerrainAdjustment, RegistryObject<StructureSet> ... requiresDistanceTo) {
        this(p_227620_, name, startPool, Optional.empty(), p_227622_, p_227623_, Optional.of(p_227625_), 80, individualTerrainAdjustment, Arrays.stream(requiresDistanceTo).map(registryObject -> (Holder)registryObject.getHolder().get()).toList());
    }

    public ValhelsiaJigsawStructure(Structure.StructureSettings p_227614_, String name, Holder<StructureTemplatePool> startPool, int p_227616_, StructureHeightProvider p_227617_, boolean individualTerrainAdjustment, RegistryObject<StructureSet> ... requiresDistanceTo) {
        this(p_227614_, name, startPool, Optional.empty(), p_227616_, p_227617_, Optional.empty(), 80, individualTerrainAdjustment, Arrays.stream(requiresDistanceTo).map(registryObject -> (Holder)registryObject.getHolder().get()).toList());
    }

    private static Function<ValhelsiaJigsawStructure, DataResult<ValhelsiaJigsawStructure>> verifyRange() {
        return structure -> {
            int i = switch (structure.m_226620_()) {
                default -> throw new IncompatibleClassChangeError();
                case TerrainAdjustment.NONE -> 0;
                case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
            };
            return structure.maxDistanceFromCenter + i > 128 ? DataResult.error((String)"Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)structure);
        };
    }

    private boolean canGenerate(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        BlockPos pos = chunkPos.m_45615_();
        ChunkGenerator generator = context.f_226622_();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        if (this.checkSurface() && !StructureUtils.isSurfaceFlat(context, this.getStructureSettings().size().get())) {
            return false;
        }
        if (!this.canGenerateOnWater()) {
            int landHeight = generator.m_223235_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
            NoiseColumn columnOfBlocks = generator.m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_());
            BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
            if (!topBlock.m_60819_().m_76178_()) {
                return false;
            }
        }
        if (StructureUtils.isStructureInDistance(generator, context.f_226624_(), context.f_226627_(), chunkPos, this.requiresDistanceTo)) {
            return false;
        }
        random.m_188584_((long)(chunkPos.f_45578_ >> 4 ^ chunkPos.f_45579_ >> 4 << 4) ^ context.f_226627_());
        return random.m_188500_() < this.getStructureSettings().spawnChance().get();
    }

    @Nonnull
    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        if (!this.canGenerate(context)) {
            return Optional.empty();
        }
        BlockPos pos = chunkPos.m_45615_();
        OptionalInt y = this.startHeight.sample(pos, context, Heightmap.Types.WORLD_SURFACE);
        if (y.isEmpty()) {
            return Optional.empty();
        }
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.maxDepth, (BlockPos)pos.m_175288_(y.getAsInt()), (boolean)true, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    @Nonnull
    public StructureType<?> m_213658_() {
        return (StructureType)ModStructureTypes.VALHELSIA_JIGSAW_STRUCTURE.get();
    }

    public ValhelsiaStructureSettings getStructureSettings() {
        return ModStructures.STRUCTURE_SETTINGS_MAP.get(this.getName());
    }

    public boolean checkSurface() {
        return this.getStructureSettings().size() != null;
    }

    public boolean canGenerateOnWater() {
        return this.m_226619_() == GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    public boolean hasMargin() {
        return this.getStructureSettings().margin().get() != 0;
    }

    public int getMargin() {
        return this.getStructureSettings().margin().get();
    }

    @Nonnull
    public BoundingBox m_226569_(@Nonnull BoundingBox boundingBox) {
        return this.hasMargin() ? boundingBox.m_191961_(this.getMargin()) : boundingBox;
    }

    public boolean hasIndividualTerrainAdjustment() {
        return this.individualTerrainAdjustment;
    }
}

