/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.energy.base;

import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.EnergySnapshot;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.impl.energy.PlatformBlockEnergyManager;
import earth.terrarium.botarium.impl.energy.PlatformItemEnergyManager;
import earth.terrarium.botarium.util.Serializable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Clearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public interface EnergyContainer
extends Serializable,
Clearable {
    public static EnergyContainer of(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        PlatformBlockEnergyManager platformBlockEnergyManager = PlatformBlockEnergyManager.of(level, pos, state, entity, direction);
        return platformBlockEnergyManager == null ? EnergyApi.getAPIEnergyContainer(level, pos, state, entity, direction) : platformBlockEnergyManager;
    }

    @Nullable
    public static EnergyContainer of(Level level, BlockPos pos, @Nullable Direction direction) {
        return EnergyContainer.of(level, pos, null, null, direction);
    }

    @Nullable
    public static EnergyContainer of(BlockEntity block, @Nullable Direction direction) {
        return EnergyContainer.of(block.m_58904_(), block.m_58899_(), block.m_58900_(), block, direction);
    }

    public static EnergyContainer of(ItemStackHolder holder) {
        return PlatformItemEnergyManager.of(holder);
    }

    public static boolean holdsEnergy(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    public static boolean holdsEnergy(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        return entity != null && entity.getCapability(ForgeCapabilities.ENERGY, direction).isPresent() || EnergyApi.getAPIEnergyContainer(level, pos, state, entity, direction) != null;
    }

    public static boolean holdsEnergy(Level level, BlockPos pos, @Nullable Direction direction) {
        return EnergyContainer.holdsEnergy(level, pos, null, null, direction);
    }

    public static boolean holdsEnergy(BlockEntity block, @Nullable Direction direction) {
        return EnergyContainer.holdsEnergy(block.m_58904_(), block.m_58899_(), block.m_58900_(), block, direction);
    }

    public long insertEnergy(long var1, boolean var3);

    default public long internalInsert(long amount, boolean simulate) {
        return this.insertEnergy(amount, simulate);
    }

    public long extractEnergy(long var1, boolean var3);

    default public long internalExtract(long amount, boolean simulate) {
        return this.extractEnergy(amount, simulate);
    }

    public void setEnergy(long var1);

    public long getStoredEnergy();

    public long getMaxCapacity();

    public long maxInsert();

    public long maxExtract();

    public boolean allowsInsertion();

    public boolean allowsExtraction();

    public EnergySnapshot createSnapshot();

    default public void readSnapshot(EnergySnapshot snapshot) {
        snapshot.loadSnapshot(this);
    }
}

