/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.biome.BOPNetherBiomes;
import biomesoplenty.common.biome.BOPOverworldBiomes;
import biomesoplenty.common.worldgen.BOPNetherRegionCommon;
import biomesoplenty.common.worldgen.BOPNetherRegionRare;
import biomesoplenty.common.worldgen.BOPOverworldRegionPrimary;
import biomesoplenty.common.worldgen.BOPOverworldRegionRare;
import biomesoplenty.common.worldgen.BOPOverworldRegionSecondary;
import biomesoplenty.common.worldgen.BOPSurfaceRuleData;
import biomesoplenty.core.BiomesOPlenty;
import biomesoplenty.init.ModConfig;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.SurfaceRules;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public class ModBiomes {
    public static void setup() {
        ModBiomes.registerBiomes();
        ModBiomes.registerVillagerTypes();
    }

    public static void setupTerraBlender() {
        Regions.register((Region)new BOPOverworldRegionPrimary((Integer)ModConfig.GenerationConfig.bopPrimaryOverworldRegionWeight.get()));
        Regions.register((Region)new BOPOverworldRegionSecondary((Integer)ModConfig.GenerationConfig.bopSecondaryOverworldRegionWeight.get()));
        Regions.register((Region)new BOPOverworldRegionRare((Integer)ModConfig.GenerationConfig.bopOverworldRareRegionWeight.get()));
        Regions.register((Region)new BOPNetherRegionCommon((Integer)ModConfig.GenerationConfig.bopNetherRegionWeight.get()));
        Regions.register((Region)new BOPNetherRegionRare((Integer)ModConfig.GenerationConfig.bopNetherRareRegionWeight.get()));
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"biomesoplenty", (SurfaceRules.RuleSource)BOPSurfaceRuleData.overworld());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.NETHER, (String)"biomesoplenty", (SurfaceRules.RuleSource)BOPSurfaceRuleData.nether());
    }

    public static void registerBiomes() {
        ModBiomes.registerBiome(BOPBiomes.AURORAL_GARDEN, () -> BOPOverworldBiomes.auroralGarden());
        ModBiomes.registerBiome(BOPBiomes.BAMBOO_GROVE, () -> BOPOverworldBiomes.bambooGrove());
        ModBiomes.registerBiome(BOPBiomes.BAYOU, () -> BOPOverworldBiomes.bayou());
        ModBiomes.registerBiome(BOPBiomes.BOG, () -> BOPOverworldBiomes.bog());
        ModBiomes.registerBiome(BOPBiomes.CHERRY_BLOSSOM_GROVE, () -> BOPOverworldBiomes.cherryBlossomGrove());
        ModBiomes.registerBiome(BOPBiomes.CLOVER_PATCH, () -> BOPOverworldBiomes.cloverPatch());
        ModBiomes.registerBiome(BOPBiomes.COLD_DESERT, () -> BOPOverworldBiomes.coldDesert());
        ModBiomes.registerBiome(BOPBiomes.CONIFEROUS_FOREST, () -> BOPOverworldBiomes.coniferousForest(false));
        ModBiomes.registerBiome(BOPBiomes.CRAG, () -> BOPOverworldBiomes.crag());
        ModBiomes.registerBiome(BOPBiomes.DEAD_FOREST, () -> BOPOverworldBiomes.deadForest());
        ModBiomes.registerBiome(BOPBiomes.DRYLAND, () -> BOPOverworldBiomes.dryland());
        ModBiomes.registerBiome(BOPBiomes.DUNE_BEACH, () -> BOPOverworldBiomes.duneBeach());
        ModBiomes.registerBiome(BOPBiomes.FIELD, () -> BOPOverworldBiomes.field(false));
        ModBiomes.registerBiome(BOPBiomes.FIR_CLEARING, () -> BOPOverworldBiomes.firClearing(false));
        ModBiomes.registerBiome(BOPBiomes.FLOODPLAIN, () -> BOPOverworldBiomes.floodplain());
        ModBiomes.registerBiome(BOPBiomes.FORESTED_FIELD, () -> BOPOverworldBiomes.field(true));
        ModBiomes.registerBiome(BOPBiomes.FUNGAL_JUNGLE, () -> BOPOverworldBiomes.fungalJungle());
        ModBiomes.registerBiome(BOPBiomes.GRASSLAND, () -> BOPOverworldBiomes.grassland());
        ModBiomes.registerBiome(BOPBiomes.HIGHLAND, () -> BOPOverworldBiomes.highland());
        ModBiomes.registerBiome(BOPBiomes.HIGHLAND_MOOR, () -> BOPOverworldBiomes.highlandMoor());
        ModBiomes.registerBiome(BOPBiomes.JADE_CLIFFS, () -> BOPOverworldBiomes.jadeCliffs());
        ModBiomes.registerBiome(BOPBiomes.LAVENDER_FIELD, () -> BOPOverworldBiomes.lavenderField(false));
        ModBiomes.registerBiome(BOPBiomes.LAVENDER_FOREST, () -> BOPOverworldBiomes.lavenderField(true));
        ModBiomes.registerBiome(BOPBiomes.LUSH_DESERT, () -> BOPOverworldBiomes.lushDesert());
        ModBiomes.registerBiome(BOPBiomes.LUSH_SAVANNA, () -> BOPOverworldBiomes.lushSavanna());
        ModBiomes.registerBiome(BOPBiomes.MAPLE_WOODS, () -> BOPOverworldBiomes.mapleWoods(false));
        ModBiomes.registerBiome(BOPBiomes.MARSH, () -> BOPOverworldBiomes.marsh());
        ModBiomes.registerBiome(BOPBiomes.MEDITERRANEAN_FOREST, () -> BOPOverworldBiomes.mediterraneanForest());
        ModBiomes.registerBiome(BOPBiomes.MUSKEG, () -> BOPOverworldBiomes.muskeg());
        ModBiomes.registerBiome(BOPBiomes.MYSTIC_GROVE, () -> BOPOverworldBiomes.mysticGrove());
        ModBiomes.registerBiome(BOPBiomes.OLD_GROWTH_DEAD_FOREST, () -> BOPOverworldBiomes.oldGrowthDeadForest());
        ModBiomes.registerBiome(BOPBiomes.OLD_GROWTH_WOODLAND, () -> BOPOverworldBiomes.woodland(true));
        ModBiomes.registerBiome(BOPBiomes.OMINOUS_WOODS, () -> BOPOverworldBiomes.ominousWoods());
        ModBiomes.registerBiome(BOPBiomes.ORCHARD, () -> BOPOverworldBiomes.orchard());
        ModBiomes.registerBiome(BOPBiomes.ORIGIN_VALLEY, () -> BOPOverworldBiomes.originValley());
        ModBiomes.registerBiome(BOPBiomes.PASTURE, () -> BOPOverworldBiomes.pasture());
        ModBiomes.registerBiome(BOPBiomes.PRAIRIE, () -> BOPOverworldBiomes.prairie());
        ModBiomes.registerBiome(BOPBiomes.PUMPKIN_PATCH, () -> BOPOverworldBiomes.pumpkinPatch());
        ModBiomes.registerBiome(BOPBiomes.RAINFOREST, () -> BOPOverworldBiomes.rainforest());
        ModBiomes.registerBiome(BOPBiomes.REDWOOD_FOREST, () -> BOPOverworldBiomes.redwoodForest());
        ModBiomes.registerBiome(BOPBiomes.ROCKY_RAINFOREST, () -> BOPOverworldBiomes.rockyRainforest());
        ModBiomes.registerBiome(BOPBiomes.ROCKY_SHRUBLAND, () -> BOPOverworldBiomes.rockyShrubland());
        ModBiomes.registerBiome(BOPBiomes.SCRUBLAND, () -> BOPOverworldBiomes.scrubland(false));
        ModBiomes.registerBiome(BOPBiomes.SEASONAL_FOREST, () -> BOPOverworldBiomes.seasonalForest());
        ModBiomes.registerBiome(BOPBiomes.SEASONAL_ORCHARD, () -> BOPOverworldBiomes.seasonalOrchard());
        ModBiomes.registerBiome(BOPBiomes.SHRUBLAND, () -> BOPOverworldBiomes.shrubland());
        ModBiomes.registerBiome(BOPBiomes.SNOWY_CONIFEROUS_FOREST, () -> BOPOverworldBiomes.coniferousForest(true));
        ModBiomes.registerBiome(BOPBiomes.SNOWY_FIR_CLEARING, () -> BOPOverworldBiomes.firClearing(true));
        ModBiomes.registerBiome(BOPBiomes.SNOWY_MAPLE_WOODS, () -> BOPOverworldBiomes.mapleWoods(true));
        ModBiomes.registerBiome(BOPBiomes.TROPICS, () -> BOPOverworldBiomes.tropics());
        ModBiomes.registerBiome(BOPBiomes.TUNDRA, () -> BOPOverworldBiomes.tundra());
        ModBiomes.registerBiome(BOPBiomes.VOLCANIC_PLAINS, () -> BOPOverworldBiomes.volcanicPlains());
        ModBiomes.registerBiome(BOPBiomes.VOLCANO, () -> BOPOverworldBiomes.volcano());
        ModBiomes.registerBiome(BOPBiomes.WASTELAND, () -> BOPOverworldBiomes.wasteland(false));
        ModBiomes.registerBiome(BOPBiomes.WETLAND, () -> BOPOverworldBiomes.wetland());
        ModBiomes.registerBiome(BOPBiomes.WOODED_SCRUBLAND, () -> BOPOverworldBiomes.scrubland(true));
        ModBiomes.registerBiome(BOPBiomes.WOODED_WASTELAND, () -> BOPOverworldBiomes.wasteland(true));
        ModBiomes.registerBiome(BOPBiomes.WOODLAND, () -> BOPOverworldBiomes.woodland(false));
        ModBiomes.registerBiome(BOPBiomes.GLOWING_GROTTO, () -> BOPOverworldBiomes.glowingGrotto());
        ModBiomes.registerBiome(BOPBiomes.SPIDER_NEST, () -> BOPOverworldBiomes.spiderNest());
        ModBiomes.registerBiome(BOPBiomes.CRYSTALLINE_CHASM, () -> BOPNetherBiomes.crystallineChasm());
        ModBiomes.registerBiome(BOPBiomes.ERUPTING_INFERNO, () -> BOPNetherBiomes.eruptingInferno());
        ModBiomes.registerBiome(BOPBiomes.UNDERGROWTH, () -> BOPNetherBiomes.undergrowth());
        ModBiomes.registerBiome(BOPBiomes.VISCERAL_HEAP, () -> BOPNetherBiomes.visceralHeap());
        ModBiomes.registerBiome(BOPBiomes.WITHERED_ABYSS, () -> BOPNetherBiomes.witheredAbyss());
    }

    private static void registerVillagerTypes() {
        ModBiomes.registerVillagerType(BOPBiomes.AURORAL_GARDEN, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.BAMBOO_GROVE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.BAYOU, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.BOG, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.CHERRY_BLOSSOM_GROVE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.CLOVER_PATCH, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.COLD_DESERT, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.CONIFEROUS_FOREST, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.CRAG, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.DEAD_FOREST, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.DRYLAND, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.DUNE_BEACH, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.FIR_CLEARING, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.FIELD, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.FLOODPLAIN, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.FORESTED_FIELD, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.FUNGAL_JUNGLE, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.GRASSLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.HIGHLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.HIGHLAND_MOOR, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.JADE_CLIFFS, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.LAVENDER_FIELD, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.LAVENDER_FOREST, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.LUSH_DESERT, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.LUSH_SAVANNA, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.MAPLE_WOODS, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.MARSH, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.MEDITERRANEAN_FOREST, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.MUSKEG, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.MYSTIC_GROVE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.OLD_GROWTH_DEAD_FOREST, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.OLD_GROWTH_WOODLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.OMINOUS_WOODS, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.ORCHARD, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.ORIGIN_VALLEY, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.PASTURE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.PRAIRIE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.PUMPKIN_PATCH, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.RAINFOREST, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.ROCKY_RAINFOREST, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.REDWOOD_FOREST, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.ROCKY_SHRUBLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.SCRUBLAND, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.SEASONAL_FOREST, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.SEASONAL_ORCHARD, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.SHRUBLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.SNOWY_CONIFEROUS_FOREST, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.SNOWY_FIR_CLEARING, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.SNOWY_MAPLE_WOODS, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.TROPICS, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.TUNDRA, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.VOLCANIC_PLAINS, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.VOLCANO, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.WASTELAND, VillagerType.f_35819_);
        ModBiomes.registerVillagerType(BOPBiomes.WETLAND, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.WOODED_SCRUBLAND, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.WOODED_WASTELAND, VillagerType.f_35819_);
        ModBiomes.registerVillagerType(BOPBiomes.WOODLAND, VillagerType.f_35821_);
    }

    public static void registerBiome(ResourceKey<Biome> key, Supplier<Biome> biomeSupplier) {
        if (ModConfig.isBiomeEnabled(key)) {
            BiomesOPlenty.BIOME_REGISTER.register(key.m_135782_().m_135815_(), biomeSupplier);
        }
    }

    private static void registerVillagerType(ResourceKey<Biome> key, VillagerType type) {
        if (ModConfig.isBiomeEnabled(key)) {
            VillagerType.f_35827_.put(key, type);
        }
    }
}

