/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.tree;

import biomesoplenty.common.worldgen.feature.configurations.MahoganyTreeConfiguration;
import biomesoplenty.common.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class MahoganyTreeFeature
extends BOPTreeFeature<MahoganyTreeConfiguration> {
    public MahoganyTreeFeature(Codec<MahoganyTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean m_225257_(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves, TreeConfiguration configBase) {
        MahoganyTreeConfiguration config = (MahoganyTreeConfiguration)configBase;
        int height = random.m_188503_(config.maxHeight - config.minHeight) + config.minHeight;
        boolean hasSpace = true;
        if (pos.m_123342_() >= 1 && pos.m_123342_() + height + 1 <= 256) {
            for (int y = pos.m_123342_(); y <= pos.m_123342_() + 1 + height; ++y) {
                int radius = 1;
                if (y == pos.m_123342_()) {
                    radius = 0;
                }
                if (y >= pos.m_123342_() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x = pos.m_123341_() - radius; x <= pos.m_123341_() + radius && hasSpace; ++x) {
                    for (int z = pos.m_123343_() - radius; z <= pos.m_123343_() + radius && hasSpace; ++z) {
                        if (y >= 0 && y < 256) {
                            if (this.canReplace((LevelAccessor)world, new BlockPos(x, y, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos soilPos = pos.m_7495_();
            Block soil = world.m_8055_(soilPos).m_60734_();
            if (pos.m_123342_() < 256 - height - 1) {
                world.m_7731_(soilPos, Blocks.f_50493_.m_49966_(), 3);
                this.generateTrunk(logs, leaves, (LevelAccessor)world, pos, height, config);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void generateTrunk(BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves, LevelAccessor world, BlockPos start, int height, MahoganyTreeConfiguration config) {
        int endHeight = height;
        for (int layer = 0; layer <= endHeight - 3; ++layer) {
            BlockPos middlePos = start.m_6630_(layer);
            if (!this.canReplace(world, middlePos)) continue;
            this.placeLog(world, middlePos, logs, config);
        }
        BlockPos branchStartPos = start.m_6630_(endHeight - 3);
        this.generateBranch(logs, leaves, world, branchStartPos, Direction.NORTH, config);
        this.generateBranch(logs, leaves, world, branchStartPos, Direction.EAST, config);
        this.generateBranch(logs, leaves, world, branchStartPos, Direction.SOUTH, config);
        this.generateBranch(logs, leaves, world, branchStartPos, Direction.WEST, config);
    }

    private void generateBranch(BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves, LevelAccessor world, BlockPos middle, Direction direction, MahoganyTreeConfiguration config) {
        int z;
        int x;
        BlockPos pos = middle;
        int length = 1 + world.m_213780_().m_188503_(2);
        for (int i = 0; i <= length - 1; ++i) {
            if (!this.canReplace(world, pos.m_5484_(direction, i + 1))) continue;
            this.placeLog(world, pos.m_5484_(direction, i + 1), direction.m_122434_(), logs, config);
        }
        int height = 1 + world.m_213780_().m_188503_(2);
        for (int i = 0; i <= height; ++i) {
            if (!this.canReplace(world, pos.m_5484_(direction, length + 1).m_6630_(i + 1))) continue;
            this.placeLog(world, pos.m_5484_(direction, length + 1).m_6630_(i + 1), Direction.Axis.Y, logs, config);
        }
        pos = pos.m_5484_(direction, length + 1).m_6630_(height + 2);
        int radius = 2;
        for (x = -(radius - 1); x <= radius - 1; ++x) {
            for (z = -(radius - 1); z <= radius - 1; ++z) {
                this.placeLeaves(world, pos.m_7918_(x, 0, z), leaves, config);
            }
        }
        for (x = -radius; x <= radius; ++x) {
            for (z = -radius; z <= radius; ++z) {
                if (!(x != -radius && x != radius || z != -radius && z != radius)) continue;
                this.placeLeaves(world, pos.m_7918_(x, -1, z), leaves, config);
            }
        }
    }
}

