/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.world.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterfortresses.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.BlockStateRandomizer;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PillarProcessor
extends StructureProcessor {
    public static final Codec<PillarProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("target_block").forGetter(config -> config.targetBlock), (App)BlockStateRandomizer.CODEC.fieldOf("target_block_output").forGetter(config -> config.targetBlockOutput), (App)BlockStateRandomizer.CODEC.fieldOf("pillar_states").forGetter(config -> config.pillarStates), (App)Direction.f_175356_.optionalFieldOf("direction", (Object)Direction.DOWN).forGetter(processor -> processor.direction), (App)Codec.INT.optionalFieldOf("pillar_length", (Object)-1).forGetter(config -> config.length)).apply((Applicative)instance, instance.stable(PillarProcessor::new)));
    public final BlockState targetBlock;
    public final BlockStateRandomizer targetBlockOutput;
    public final BlockStateRandomizer pillarStates;
    public final Direction direction;
    public final int length;

    private PillarProcessor(BlockState targetBlock, BlockStateRandomizer targetBlockOutput, BlockStateRandomizer pillarStates, Direction direction, int length) {
        this.targetBlock = targetBlock;
        this.targetBlockOutput = targetBlockOutput;
        this.pillarStates = pillarStates;
        this.direction = direction;
        this.length = length;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.f_74676_.m_60713_(this.targetBlock.m_60734_())) {
            WorldGenRegion worldGenRegion;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).m_143488_().equals((Object)new ChunkPos(blockInfoGlobal.f_74675_))) {
                return blockInfoGlobal;
            }
            RandomSource random = structurePlacementData.m_230326_(blockInfoGlobal.f_74675_);
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_, this.targetBlockOutput.get(random), blockInfoGlobal.f_74677_);
            BlockPos.MutableBlockPos mutable = blockInfoGlobal.f_74675_.m_122032_().m_122173_(Direction.DOWN);
            BlockState currBlockState = levelReader.m_8055_((BlockPos)mutable);
            while (mutable.m_123342_() > levelReader.m_141937_() && mutable.m_123342_() < levelReader.m_151558_() && (currBlockState.m_60795_() || !levelReader.m_6425_((BlockPos)mutable).m_76178_())) {
                StructureContext ctx = new StructureContext.Builder().pieceMinY(mutable.m_123342_()).pieceMaxY(mutable.m_123342_()).build();
                levelReader.m_46865_((BlockPos)mutable).m_6978_((BlockPos)mutable, this.pillarStates.get(random, ctx), false);
                mutable.m_122173_(Direction.DOWN);
                currBlockState = levelReader.m_8055_((BlockPos)mutable);
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorTypeModule.PILLAR_PROCESSOR;
    }
}

