/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.forge.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dcshadow.com.vdurmont.emoji.EmojiParser;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.TextReplacementConfig;
import dcshadow.net.kyori.adventure.text.event.ClickEvent;
import dcshadow.net.kyori.adventure.text.event.HoverEvent;
import dcshadow.net.kyori.adventure.text.format.Style;
import dcshadow.net.kyori.adventure.text.format.TextColor;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import dcshadow.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.ComponentUtils;
import de.erdbeerbaerlp.dcintegration.common.util.McServerInterface;
import de.erdbeerbaerlp.dcintegration.common.util.MinecraftPermission;
import de.erdbeerbaerlp.dcintegration.forge.DiscordIntegrationMod;
import de.erdbeerbaerlp.dcintegration.forge.command.DCCommandSender;
import de.erdbeerbaerlp.dcintegration.forge.util.ForgeMessageUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.requests.RestAction;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;

public class ForgeServerInterface
implements McServerInterface {
    @Override
    public int getMaxPlayers() {
        return ServerLifecycleHooks.getCurrentServer() == null ? -1 : ServerLifecycleHooks.getCurrentServer().m_7418_();
    }

    @Override
    public int getOnlinePlayers() {
        return ServerLifecycleHooks.getCurrentServer() == null ? -1 : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11309_();
    }

    @Override
    public void sendIngameMessage(Component msg) {
        List l = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
        try {
            for (ServerPlayer p : l) {
                if (!this.playerHasPermissions(p.m_20148_(), MinecraftPermission.READ_MESSAGES, MinecraftPermission.USER)) {
                    return;
                }
                if (DiscordIntegration.INSTANCE.ignoringPlayers.contains(p.m_20148_()) || LinkManager.isPlayerLinked(p.m_20148_()) && LinkManager.getLink(null, (UUID)p.m_20148_()).settings.ignoreDiscordChatIngame) continue;
                Map.Entry<Boolean, Component> ping = ComponentUtils.parsePing(msg, p.m_20148_(), p.m_7755_().getString());
                String jsonComp = ((String)GsonComponentSerializer.gson().serialize(ping.getValue())).replace("\\\\n", "\n");
                net.minecraft.network.chat.Component comp = ComponentArgument.m_87114_().parse(new StringReader(jsonComp));
                p.m_213846_(comp);
                if (!ping.getKey().booleanValue() || !LinkManager.isPlayerLinked(p.m_20148_()) || !LinkManager.getLink(null, (UUID)p.m_20148_()).settings.pingSound) continue;
                p.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(SoundEvents.f_12216_, SoundSource.MASTER, p.m_20182_().f_82479_, p.m_20182_().f_82480_, p.m_20182_().f_82481_, 1.0f, 1.0f, 1L));
            }
            String jsonComp = ((String)GsonComponentSerializer.gson().serialize(msg)).replace("\\\\n", "\n");
            net.minecraft.network.chat.Component comp = ComponentArgument.m_87114_().parse(new StringReader(jsonComp));
            ServerLifecycleHooks.getCurrentServer().m_213846_(comp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendIngameReaction(Member member, RestAction<Message> retrieveMessage, UUID targetUUID, EmojiUnion reactionEmote) {
        List l = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
        for (ServerPlayer p : l) {
            if (!p.m_20148_().equals(targetUUID) || DiscordIntegration.INSTANCE.ignoringPlayers.contains(p.m_20148_()) || !LinkManager.isPlayerLinked(p.m_20148_()) || LinkManager.getLink(null, (UUID)p.m_20148_()).settings.ignoreDiscordChatIngame || LinkManager.getLink(null, (UUID)p.m_20148_()).settings.ignoreReactions) continue;
            Object emote = reactionEmote.getType() == Emoji.Type.UNICODE ? EmojiParser.parseToAliases(reactionEmote.getName()) : ":" + reactionEmote.getName() + ":";
            Style.Builder memberStyle = Style.style();
            if (Configuration.instance().messages.discordRoleColorIngame) {
                memberStyle = memberStyle.color(TextColor.color(member.getColorRaw()));
            }
            Component user = Component.text(member.getEffectiveName()).style((Style.Builder)memberStyle.clickEvent(ClickEvent.suggestCommand("<@" + member.getId() + ">")).hoverEvent(HoverEvent.showText(Component.text(Localization.instance().discordUserHover.replace("%user#tag%", member.getUser().getAsTag()).replace("%user%", member.getEffectiveName()).replace("%id%", member.getUser().getId())))));
            TextReplacementConfig userReplacer = ComponentUtils.replaceLiteral("%user%", user);
            TextReplacementConfig emoteReplacer = ComponentUtils.replaceLiteral("%emote%", (String)emote);
            Component out = LegacyComponentSerializer.legacySection().deserialize(Localization.instance().reactionMessage).replaceText(userReplacer).replaceText(emoteReplacer);
            if (Localization.instance().reactionMessage.contains("%msg%")) {
                retrieveMessage.submit().thenAccept(m -> {
                    String msg = ForgeMessageUtils.formatEmoteMessage(m.getMentions().getCustomEmojis(), m.getContentDisplay());
                    TextReplacementConfig msgReplacer = ComponentUtils.replaceLiteral("%msg%", msg);
                    this.sendReactionMCMessage(p, out.replaceText(msgReplacer));
                });
                continue;
            }
            this.sendReactionMCMessage(p, out);
        }
    }

    @Override
    public void runMcCommand(String cmd, CompletableFuture<InteractionHook> cmdMsg, User user) {
        DCCommandSender s = new DCCommandSender(cmdMsg, user);
        try {
            ServerLifecycleHooks.getCurrentServer().m_129892_().m_82094_().execute(cmd.trim(), (Object)s.createCommandSourceStack());
        }
        catch (CommandSyntaxException e) {
            s.m_213846_((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)e.getMessage()));
        }
    }

    @Override
    public HashMap<UUID, String> getPlayers() {
        HashMap<UUID, String> players = new HashMap<UUID, String>();
        for (ServerPlayer p : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            players.put(p.m_20148_(), p.m_5446_().getString().isEmpty() ? p.m_7755_().getString() : p.m_5446_().getString());
        }
        return players;
    }

    @Override
    public void sendIngameMessage(String msg, UUID player) {
        ServerPlayer p = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(player);
        if (p != null) {
            p.m_213846_((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)msg));
        }
    }

    @Override
    public boolean isOnlineMode() {
        return Configuration.instance().bungee.isBehindBungee || ServerLifecycleHooks.getCurrentServer().m_129797_();
    }

    private void sendReactionMCMessage(ServerPlayer target, Component msgComp) {
        if (!this.playerHasPermissions(target.m_20148_(), MinecraftPermission.READ_MESSAGES, MinecraftPermission.USER)) {
            return;
        }
        String jsonComp = ((String)GsonComponentSerializer.gson().serialize(msgComp)).replace("\\\\n", "\n");
        try {
            net.minecraft.network.chat.Component comp = ComponentArgument.m_87114_().parse(new StringReader(jsonComp));
            target.m_213846_(comp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getNameFromUUID(UUID uuid) {
        return ServerLifecycleHooks.getCurrentServer().m_129925_().fillProfileProperties(new GameProfile(uuid, ""), false).getName();
    }

    @Override
    public String getLoaderName() {
        return "Forge";
    }

    @Override
    public boolean playerHasPermissions(UUID player, String ... permissions) {
        ServerPlayer serverPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(player);
        for (String p : permissions) {
            if (!(serverPlayer != null ? (Boolean)PermissionAPI.getPermission((ServerPlayer)serverPlayer, DiscordIntegrationMod.nodes.get(p), (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false : (Boolean)PermissionAPI.getOfflinePermission((UUID)player, DiscordIntegrationMod.nodes.get(p), (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false)) continue;
            return true;
        }
        return false;
    }
}

