/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.forge.mixin;

import com.mojang.authlib.GameProfile;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.MinecraftPermission;
import java.net.SocketAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public class MixinPlayerLogin {
    @Inject(method={"canPlayerLogin"}, at={@At(value="HEAD")}, cancellable=true)
    private void canLogin(SocketAddress address, GameProfile profile, CallbackInfoReturnable<Component> cir) {
        if (Configuration.instance().linking.whitelistMode && ServerLifecycleHooks.getCurrentServer().m_129797_()) {
            LinkManager.checkGlobalAPI(profile.getId());
            if (DiscordIntegration.INSTANCE.getServerInterface().playerHasPermissions(profile.getId(), MinecraftPermission.BYPASS_WHITELIST, MinecraftPermission.ADMIN)) {
                return;
            }
            try {
                if (!LinkManager.isPlayerLinked(profile.getId())) {
                    cir.setReturnValue((Object)Component.m_237113_((String)Localization.instance().linking.notWhitelistedCode.replace("%code%", "" + LinkManager.genLinkNumber(profile.getId()))));
                } else if (!DiscordIntegration.INSTANCE.canPlayerJoin(profile.getId())) {
                    cir.setReturnValue((Object)Component.m_237113_((String)Localization.instance().linking.notWhitelistedRole));
                }
            }
            catch (IllegalStateException e) {
                cir.setReturnValue((Object)Component.m_237113_((String)("An error occured\nPlease check Server Log for more information\n\n" + e)));
            }
        }
    }
}

