/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.storage.linking.database;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.PlayerLink;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.database.DBInterface;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class JSONInterface
extends DBInterface {
    public static final File jsonFile = new File(DiscordIntegration.discordDataDir, "LinkedPlayers.json");

    @Override
    public void connect() {
    }

    @Override
    public void initialize() {
        block8: {
            try {
                if (!jsonFile.getParentFile().exists()) {
                    jsonFile.getParentFile().mkdirs();
                }
                if (jsonFile.exists()) break block8;
                jsonFile.createNewFile();
                try (FileWriter writer = new FileWriter(jsonFile);){
                    gson.toJson((JsonElement)new JsonArray(), (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isConnected() {
        return jsonFile.exists();
    }

    @Override
    public void addLink(PlayerLink link) {
        DiscordIntegration.LOGGER.info("JSONInterface addLink | Saving " + link);
        JsonArray json = JSONInterface.getJson();
        DiscordIntegration.LOGGER.info("JSONInterface addLink | json (old): " + json);
        for (JsonElement e : json) {
            PlayerLink o = (PlayerLink)gson.fromJson(e, PlayerLink.class);
            if (!o.discordID.equals(link.discordID) && (o.floodgateUUID == null || o.floodgateUUID.isEmpty() || !o.floodgateUUID.equals(link.floodgateUUID)) && (o.mcPlayerUUID == null || o.mcPlayerUUID.isEmpty() || !o.mcPlayerUUID.equals(link.mcPlayerUUID))) continue;
            json.remove(e);
            DiscordIntegration.LOGGER.info("JSONInterface addLink | Removing old link from json " + o.discordID);
            break;
        }
        json.add((JsonElement)gson.toJsonTree((Object)link).getAsJsonObject());
        DiscordIntegration.LOGGER.info("JSONInterface addLink | json (new): " + json);
        try (FileWriter writer = new FileWriter(jsonFile);){
            gson.toJson((JsonElement)json, (Appendable)writer);
            DiscordIntegration.LOGGER.info("JSONInterface addLink | Written to File");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void removeLink(String id) {
        for (JsonElement e : JSONInterface.getJson()) {
            PlayerLink o = (PlayerLink)gson.fromJson(e, PlayerLink.class);
            if (o.discordID == null || !o.discordID.equals(id)) continue;
            JsonArray json = JSONInterface.getJson();
            json.remove(e);
            try (FileWriter writer = new FileWriter(jsonFile);){
                gson.toJson((JsonElement)json, (Appendable)writer);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    @Override
    public PlayerLink[] getAllLinks() {
        return (PlayerLink[])gson.fromJson((JsonElement)JSONInterface.getJson(), PlayerLink[].class);
    }

    private static JsonArray getJson() {
        try {
            FileReader is = new FileReader(jsonFile);
            JsonArray a = JsonParser.parseReader((Reader)is).getAsJsonArray();
            is.close();
            return a;
        }
        catch (IOException e) {
            return new JsonArray();
        }
    }
}

