/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.storage;

import dcshadow.com.moandjiezana.toml.Toml;
import dcshadow.com.moandjiezana.toml.TomlComment;
import dcshadow.com.moandjiezana.toml.TomlIgnore;
import dcshadow.com.moandjiezana.toml.TomlWriter;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.configCmd.ConfigCommand;
import de.erdbeerbaerlp.dcintegration.common.util.GameType;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import de.erdbeerbaerlp.dcintegration.common.util.UpdateChecker;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.utils.data.DataObject;

public class Configuration {
    @TomlIgnore
    private static final ConfigCommand[] defaultCommands;
    @TomlIgnore
    private static Configuration INSTANCE;
    @TomlComment(value={"General options for the bot"})
    public General general = new General();
    @TomlComment(value={"Some settings that can be tweaked to increase compatibility with other mods, if required"})
    public Compatibility compatibility = new Compatibility();
    @TomlComment(value={"Configuration options for commands"})
    public Commands commands = new Commands();
    @TomlComment(value={"Toggle some message related features"})
    public Messages messages = new Messages();
    @TomlComment(value={"Settings for embed mode"})
    public EmbedMode embedMode = new EmbedMode();
    @TomlComment(value={"Advanced options"})
    public Advanced advanced = new Advanced();
    @TomlComment(value={"Config options which only have an effect when using forge"})
    public ForgeSpecific forgeSpecific = new ForgeSpecific();
    @TomlComment(value={"Configuration for linking"})
    public Linking linking = new Linking();
    @TomlComment(value={"Webhook configuration"})
    public Webhook webhook = new Webhook();
    @TomlComment(value={"Configuration for the in-game command '/discord'"})
    public IngameCommand ingameCommand = new IngameCommand();
    @TomlComment(value={"The command log channel is an channel where every command execution gets logged"})
    public CommandLog commandLog = new CommandLog();
    @TomlComment(value={"Configure votifier integration here", "(Spigot only)"})
    public Votifier votifier = new Votifier();
    @TomlComment(value={"Configure Dynmap integration here"})
    public Dynmap dynmap = new Dynmap();
    @TomlComment(value={"Configure some plugin-specific BStats settings here", "Everything can be seen here: https://bstats.org/plugin/bukkit/DiscordIntegration/9765", "", "Does not apply to fabric yet, as there is no bstats for it"})
    public BStats bstats = new BStats();
    @TomlComment(value={"Settings for servers running as Bungeecord-suberver"})
    public Bungee bungee = new Bungee();

    public static Configuration instance() {
        return INSTANCE;
    }

    public void loadConfig() throws IOException, IllegalStateException {
        if (!DiscordIntegration.configFile.exists()) {
            INSTANCE = new Configuration();
            INSTANCE.saveConfig();
            return;
        }
        INSTANCE = new Toml().read(DiscordIntegration.configFile).to(Configuration.class);
        INSTANCE.saveConfig();
    }

    public void saveConfig() throws IOException {
        if (!DiscordIntegration.configFile.exists()) {
            if (!DiscordIntegration.configFile.getParentFile().exists()) {
                DiscordIntegration.configFile.getParentFile().mkdirs();
            }
            DiscordIntegration.configFile.createNewFile();
        }
        TomlWriter w = new TomlWriter.Builder().indentValuesBy(2).indentTablesBy(4).padArrayDelimitersBy(2).build();
        w.write((Object)this, DiscordIntegration.configFile);
    }

    static {
        ArrayList<ConfigCommand> defaultCmds = new ArrayList<ConfigCommand>();
        ConfigCommand kick = new ConfigCommand();
        kick.name = "kick";
        kick.description = "Kicks an player from the Server";
        kick.mcCommand = "kick %player% %reason%";
        kick.args = new ConfigCommand.CommandArgument[]{new ConfigCommand.CommandArgument("player", "The player to be kicked"), new ConfigCommand.CommandArgument("reason", "Reason for the kick", true)};
        kick.adminOnly = true;
        defaultCmds.add(kick);
        ConfigCommand stop = new ConfigCommand();
        stop.name = "stop";
        stop.description = "Stops the server";
        stop.mcCommand = "stop";
        stop.adminOnly = true;
        defaultCmds.add(stop);
        ConfigCommand kill = new ConfigCommand();
        kill.name = "kill";
        kill.description = "Kills an Player or Entity";
        kill.mcCommand = "kill %target%";
        kill.adminOnly = true;
        kill.args = new ConfigCommand.CommandArgument[]{new ConfigCommand.CommandArgument("target", "The target(s) for the kill command.")};
        defaultCmds.add(kill);
        defaultCommands = defaultCmds.toArray(new ConfigCommand[0]);
        INSTANCE = new Configuration();
    }

    public static class General {
        @TomlComment(value={"Insert your Bot Token here!", "DO NOT SHARE IT WITH ANYONE!"})
        public String botToken = "INSERT BOT TOKEN HERE";
        @TomlComment(value={"The channel ID where the bot will be working in"})
        public String botChannel = "000000000";
        @TomlComment(value={"The bots status message", "", "PLACEHOLDERS:", "%online% - Online Players", "%max% - Maximum Player Amount"})
        public String botStatusName = "%online% players online";
        @TomlComment(value={"The bots status message for 1 online player, set to empty to use botStatusName", "PLACEHOLDERS:", "%online% - Online Players", "%max% - Maximum Player Amount"})
        public String botStatusNameSingular = "%online% player online";
        @TomlComment(value={"The bots status message for no online players, set to empty to use botStatusName", "PLACEHOLDERS:", "%online% - Online Players", "%max% - Maximum Player Amount"})
        public String botStatusNameEmpty = "No-one is online";
        @TomlComment(value={"Type of the bots status", "Allowed Values: DISABLED,PLAYING,WATCHING,LISTENING,STREAMING,COMPETING,CUSTOM"})
        public GameType botStatusType = GameType.CUSTOM;
        @TomlComment(value={"URL of the bots stream when using the status type 'STREAMING'", "Has to start with https://twitch.tv/ or https://www.youtube.com/watch?v="})
        public String streamingURL = "https://www.youtube.com/watch?v=dQw4w9WgXcQ";
        @TomlComment(value={"Enable checking for updates?", "Notification will be shown after every server start in log when update is available"})
        public boolean enableUpdateChecker = true;
        @TomlComment(value={"The minimum release type for the update checker to notify", "Allowed values: release, beta, alpha"})
        public UpdateChecker.ReleaseType updateCheckerMinimumReleaseType = UpdateChecker.ReleaseType.beta;
        @TomlComment(value={"Set to false to disable config migration from other mods/plugins to this one", "This does not prevent updating of this config after mod updates"})
        public boolean allowConfigMigration = true;
        @TomlComment(value={"Set to true to suppress warning of unsafe mod download location"})
        public boolean ignoreFileSource = false;
        @TomlComment(value={"Set to true to allow relaying webhook messages"})
        public boolean allowWebhookMessages = false;
    }

    public static class Compatibility {
        @TomlComment(value={"Disables modifying sent chat messages in-game to show who was pinged. (Will not convert <@1234567890> to @User)", "This may fix mods also modifying sent messages"})
        public boolean disableParsingMentionsIngame = false;
    }

    public static class Commands {
        @TomlComment(value={"Toggle the entire command feature", "Disabling this will disable registering any commands to discord"})
        public boolean enabled = true;
        @TomlComment(value={"The Role IDs of your Admin Roles", "Now supports multiple roles which can access admin commands"})
        public String[] adminRoleIDs = new String[0];
        @TomlComment(value={"Add your custom commands here", "You can also generate some on https://erdbeerbaerlp.de/dcintegration-commands/"})
        public ConfigCommand[] customCommands = defaultCommands;
        @TomlComment(value={"Enable the list command in discord"})
        public boolean listCmdEnabled = true;
        @TomlComment(value={"Show list command only for the user who runs it"})
        public boolean hideListCmd = true;
        @TomlComment(value={"Enable the uptime command in discord"})
        public boolean uptimeCmdEnabled = true;
        @TomlComment(value={"Show uptime command only for the user who runs it"})
        public boolean hideUptimeCmd = false;
        @TomlComment(value={"Enables using local commands for faster registration", "Local Commands will register all slash commands directly to the server instead of to the bot", "Setting this to true requires the bot to be invited with the scope 'application.commands' to work"})
        public boolean useLocalCommands = false;
    }

    public static class Messages {
        @TomlComment(value={"Changing this to an language key (like en-US, de-DE) will always attempt to download the latest language file from https://github.com/ErdbeerbaerLP/Discord-Integration-Translations", "Setting to 'local' disables downloading"})
        public String language = "local";
        @TomlComment(value={"Should /say output be sent to discord?"})
        public boolean sendOnSayCommand = true;
        @TomlComment(value={"Should /me output be sent to discord?"})
        public boolean sendOnMeCommand = true;
        @TomlComment(value={"Adding an selector (ex. @a ) here will relay all /tellraw messages sent with that exact same selector to discord.", "Leave blank to disable"})
        public String tellrawSelector = "";
        @TomlComment(value={"When an /say command's message starts with this prefix, it will not be sent to discord", "Useful for hiding system messages by prepending it with this"})
        public String sayCommandIgnoredPrefix = "\u00a74\u00a76\u00a7k\u00a7r";
        @TomlComment(value={"Should Discord users have their role color in-game?"})
        public boolean discordRoleColorIngame = true;
        @TomlComment(value={"Should you be able to hover and click on the discord username in-game?"})
        public boolean enableHoverMessage = true;
    }

    public static class EmbedMode {
        @TomlComment(value={"Enabling this will send configured messages as embed messages", "See below configuration options of this category to see what messages can be moved to embeds"})
        public boolean enabled = false;
        @TomlComment(value={"Starting & Started Messages"})
        public EmbedEntry startMessages = new EmbedEntry(true, TextColors.DISCORD_GREEN.asHexString());
        @TomlComment(value={"Stop & Crash Messages"})
        public EmbedEntry stopMessages = new EmbedEntry(true, TextColors.DISCORD_RED.asHexString());
        @TomlComment(value={"Player join message"})
        public EmbedEntry playerJoinMessage = new EmbedEntry(true, TextColors.DISCORD_GREEN.asHexString());
        @TomlComment(value={"Player leave messages", "Also containing timeouts"})
        public EmbedEntry playerLeaveMessages = new EmbedEntry(true, TextColors.DISCORD_RED.asHexString());
        @TomlComment(value={"Player Death message"})
        public EmbedEntry deathMessage = new EmbedEntry(true, TextColors.BLACK.asHexString());
        @TomlComment(value={"Advancement messages"})
        public EmbedEntry advancementMessage = new EmbedEntry(true, TextColors.DISCORD_YELLOW.asHexString());
        @TomlComment(value={"Player chat messages"})
        public ChatEmbedEntry chatMessages = new ChatEmbedEntry(true, TextColors.of(Color.GRAY).asHexString());

        public static class EmbedEntry {
            @TomlComment(value={"Send as embed?"})
            public boolean asEmbed;
            @TomlComment(value={"Color of embed bar"})
            public String colorHexCode;
            @TomlComment(value={"Custom embed JSON, will overwrite color setting. For more info, check the documentation at https://github.com/ErdbeerbaerLP/DiscordIntegration-Core/wiki/embed-mode or ask on discord."})
            public String customJSON = "";

            EmbedEntry(boolean defaultEnabled, String defaultColor) {
                this.asEmbed = defaultEnabled;
                this.colorHexCode = defaultColor;
            }

            public EmbedBuilder toEmbed() {
                return new EmbedBuilder().setColor(Color.decode(this.colorHexCode));
            }

            public EmbedBuilder toEmbedJson(String jsonString) {
                DataObject json = DataObject.fromJson(jsonString);
                return EmbedBuilder.fromData(json);
            }
        }

        public static class ChatEmbedEntry
        extends EmbedEntry {
            @TomlComment(value={"Generate unique chat colors from player uuid?"})
            public boolean generateUniqueColors = true;

            ChatEmbedEntry(boolean defaultEnabled, String defaultColor) {
                super(defaultEnabled, defaultColor);
            }
        }
    }

    public static class Advanced {
        @TomlComment(value={"Custom channel ID for server specific messages (like Join/leave)", "Leave 'default' to use default channel"})
        public String serverChannelID = "default";
        @TomlComment(value={"Custom channel ID for death messages", "Leave 'default' to use default channel"})
        public String deathsChannelID = "default";
        @TomlComment(value={"Custom channel for for in-game messages", "Leave 'default' to use default channel"})
        public String chatOutputChannelID = "default";
        @TomlComment(value={"Custom channel where messages get sent to minecraft", "Leave 'default' to use default channel"})
        public String chatInputChannelID = "default";
        @TomlComment(value={"Allows you to change the target URL for the API to make it usable with custom discord instances like Spacebar", "DO NOT CHANGE if you don't know what you are doing!!"})
        public String baseAPIUrl = "https://discord.com";
    }

    public static class ForgeSpecific {
        @TomlComment(value={"A list of blacklisted modids", "Adding one will prevent the mod to send messages to discord using forges IMC system"})
        public String[] IMC_modIdBlacklist = new String[]{"examplemod"};
        @TomlComment(value={"Show item information, which is visible on hover in-game, as embed in discord?"})
        public boolean sendItemInfo = true;
    }

    public static class Linking {
        @TomlComment(value={"Unlink players when they leave the discord server for whatever reason (ex. leave,kick,ban)?"})
        public boolean unlinkOnLeave = true;
        @TomlComment(value={"Should discord linking be enabled?", "If whitelist is on, this can NOT be disabled", "DOES NOT WORK IN OFFLINE MODE!"})
        public boolean enableLinking = true;
        @TomlComment(value={"Set Discord nicknames to match Minecraft usernames when linked"})
        public boolean shouldNickname = false;
        @TomlComment(value={"Enable global linking?", "Does not work in offline mode"})
        public boolean globalLinking = true;
        @TomlComment(value={"Database interface class", "This allows you to change your database implementation", "Add database implementations using the addon system", "Do not change without knowing what you are doing"})
        public String databaseClass = "de.erdbeerbaerlp.dcintegration.common.storage.linking.database.JSONInterface";
        @TomlComment(value={"Role ID of an role an player should get when he links his discord account", "Leave as 0 to disable"})
        public String linkedRoleID = "0";
        @TomlComment(value={"Enable discord based whitelist?", "This will override the link config!", "To whitelist use the whitelist command in the bot DMs"})
        public boolean whitelistMode = false;
        @TomlComment(value={"Adding Role IDs here will require the players to have at least ONE of these roles to link account"})
        public String[] requiredRoles = new String[0];
        @TomlComment(value={"Adding setting keys to this array will prevent those settings to be changed", "They will still show up in the list though"})
        public String[] settingsBlacklist = new String[0];
        @TomlComment(value={"Allows you to configure the default values of some personal settings"})
        public PersonalSettingsDefaults personalSettingsDefaults = new PersonalSettingsDefaults();

        public static class PersonalSettingsDefaults {
            public boolean default_useDiscordNameInChannel = true;
            public boolean default_ignoreReactions = false;
            public boolean default_pingSound = true;
        }
    }

    public static class Webhook {
        @TomlComment(value={"Whether or not the bot should use a webhook (it will create one)", "This will only work in standard channels"})
        public boolean enable = false;
        @TomlComment(value={"The avatar to be used for server messages"})
        public String serverAvatarURL = "https://raw.githubusercontent.com/ErdbeerbaerLP/Discord-Chat-Integration/master/images/srv.png";
        @TomlComment(value={"The name to be used for server messages"})
        public String serverName = "Minecraft Server";
        @TomlComment(value={"The URL where the player avatar gets fetched from", "", "PLACEHOLDERS:", "%uuid% - Returns the player's UUID with dashes", "%uuid_dashless% - Returns the player's UUID without dashes", "%name% - Returns the player's name", "%randomUUID% - Returns an random UUID which can be used to prevent discord cache"})
        public String playerAvatarURL = "https://minotar.net/avatar/%uuid%?randomuuid=%randomUUID%";
        public String webhookName = "MC_DC_INTEGRATION";
    }

    public static class IngameCommand {
        @TomlComment(value={"Enable the /discord command to show an custom message with invite URL?"})
        public boolean enabled = true;
        @TomlComment(value={"The message displayed when typing /discord in the server chat"})
        public String message = "Join our discord! https://discord.gg/myserver";
        @TomlComment(value={"The message shown when hovering the /discord command message"})
        public String hoverMessage = "Click to open the invite url";
        @TomlComment(value={"The url to open when clicking the /discord command text"})
        public String inviteURL = "https://discord.gg/myserver";
    }

    public static class CommandLog {
        @TomlComment(value={"Channel ID for the command log channel", "Leave 0 to disable"})
        public String channelID = "0";
        @TomlComment(value={"The format of the log messages", "", "PLACEHOLDERS:", "%sender% - The name of the Command Source", "%cmd% - executed command (e.g. \"say Hello World\"", "%cmd-no-args% - Command without arguments (e.g. \"say\""})
        public String message = "%sender% executed command `%cmd%`";
        @TomlComment(value={"A list of commands that should NOT be logged"})
        public String[] ignoredCommands = new String[]{"list", "help", "?"};
    }

    public static class Votifier {
        @TomlComment(value={"Should votifier messages be sent to discord?"})
        public boolean enabled = true;
        @TomlComment(value={"Custom channel ID for Votifier messages", "Leave 'default' to use default channel"})
        public String votifierChannelID = "default";
        @TomlComment(value={"The message format of the votifier message", "", "PLACEHOLDERS:", "%player% - The player\u00b4s name", "%site% - The name of the vote site", "%addr% - (IP) Address of the site"})
        public String message = ":ballot_box: %player% just voted on %site%";
        @TomlComment(value={"Name of the webhook title"})
        public String name = "Votifier";
        @TomlComment(value={"URL of the webhook avatar image"})
        public String avatarURL = "https://www.cubecraft.net/attachments/bkjvmqn-png.126824/";
    }

    public static class Dynmap {
        @TomlComment(value={"The message format of the message forwarded to discord", "", "PLACEHOLDERS:", "%sender% - The sender\u00b4s name", "%msg% - The Message"})
        public String dcMessage = "<%sender%> %msg%";
        @TomlComment(value={"Custom channel ID for dynmap chat", "Leave 'default' to use default channel"})
        public String dynmapChannelID = "default";
        @TomlComment(value={"Name of the webhook title"})
        public String name = "Dynmap Web-Chat";
        @TomlComment(value={"URL of the webhook avatar image"})
        public String avatarURL = "https://static.wikia.nocookie.net/minecraft_gamepedia/images/9/91/Map_Zoom_0.png/revision/latest?cb=20200311153330";
        @TomlComment(value={"The name format of the message forwarded to the dynmap web-chat", "", "PLACEHOLDERS:", "%name% - The discord name of the sender (including nickname)", "%name#tag% - The discord name with tag of the sender (without nickname)"})
        public String webName = "%name% (discord)";
        @TomlComment(value={"Name shown in discord when no name was specified on the website"})
        public String unnamed = "Unnamed";
    }

    public static class BStats {
        @TomlComment(value={"Allow sending of installed addon stats (Name and version of installed addons)"})
        public boolean sendAddonStats = true;
    }

    public static class Bungee {
        @TomlComment(value={"Set this to true if the server is running as an subserver of an bungeecord network and therefore needs to be in offline mode", "Setting this will force account linking in offline mode", "Do NOT use for actual offline mode servers, as this will break the linking feature because of the UUIDs!", "", "Currently no support for floodgate running on bungee"})
        public boolean isBehindBungee = false;
    }
}

