/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.discordCommands;

import dcshadow.org.apache.commons.lang3.ArrayUtils;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.DiscordCommand;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.PlayerLink;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.PlayerSettings;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;

public class CommandSettings
extends DiscordCommand {
    protected CommandSettings(String name, String desc) {
        super(name, desc);
    }

    public CommandSettings() {
        super("settings", Localization.instance().commands.descriptions.settings);
        Field[] settingsFields;
        ArrayList<Command.Choice> settings = new ArrayList<Command.Choice>();
        for (Field f : settingsFields = PlayerSettings.class.getDeclaredFields()) {
            settings.add(new Command.Choice(f.getName(), f.getName()));
        }
        this.addSubcommands(new SubcommandData("get", Localization.instance().commands.cmdSett_get).addOptions(new OptionData(OptionType.STRING, "key", Localization.instance().commands.cmdSett_key, false).addChoices(settings)), new SubcommandData("set", Localization.instance().commands.cmdSett_set).addOptions(new OptionData(OptionType.STRING, "key", Localization.instance().commands.cmdSett_key, true).addChoices(settings), new OptionData(OptionType.BOOLEAN, "value", Localization.instance().commands.cmdSett_val)));
    }

    @Override
    public void execute(SlashCommandInteractionEvent ev, ReplyCallbackAction replyCallbackAction) {
        CompletableFuture reply = replyCallbackAction.setEphemeral(true).submit();
        if (!LinkManager.isDiscordUserLinked(ev.getUser().getId())) {
            reply.thenAccept(c -> c.sendMessage(Localization.instance().linking.notLinked.replace("%method%", Configuration.instance().linking.whitelistMode ? Localization.instance().linking.linkMethodWhitelistCode.replace("%prefix%", "/") : Localization.instance().linking.linkMethodIngame)).queue());
            return;
        }
        OptionMapping key = ev.getOption("key");
        OptionMapping value = ev.getOption("value");
        String subcommandName = ev.getSubcommandName();
        if (subcommandName != null) {
            switch (subcommandName) {
                case "get": {
                    if (key != null) {
                        if (CommandSettings.getSettings().containsKey(key.getAsString())) {
                            PlayerLink link = LinkManager.getLink(ev.getUser().getId(), null);
                            reply.thenAccept(c -> {
                                try {
                                    c.sendMessage(Localization.instance().personalSettings.personalSettingGet.replace("%bool%", link.settings.getClass().getField(key.getAsString()).getBoolean(link) ? "true" : "false")).queue();
                                }
                                catch (IllegalAccessException | NoSuchFieldException e) {
                                    e.printStackTrace();
                                }
                            });
                            break;
                        }
                        reply.thenAccept(c -> c.sendMessage(Localization.instance().personalSettings.invalidPersonalSettingKey.replace("%key%", key.getAsString())).queue());
                        break;
                    }
                    EmbedBuilder b = new EmbedBuilder();
                    PlayerLink link = LinkManager.getLink(ev.getUser().getId(), null);
                    CommandSettings.getSettings().forEach((name, desc) -> {
                        if (Configuration.instance().webhook.enable || !name.equals("useDiscordNameInChannel")) {
                            try {
                                b.addField(name + " == " + ((Boolean)link.settings.getClass().getDeclaredField((String)name).get(link) != false ? "true" : "false"), (String)desc, false);
                            }
                            catch (IllegalAccessException | NoSuchFieldException e) {
                                b.addField(name + " == Unknown", (String)desc, false);
                            }
                        }
                    });
                    b.setAuthor(Localization.instance().personalSettings.personalSettingsHeader);
                    reply.thenAccept(c -> c.editOriginalEmbeds(b.build()).queue());
                    break;
                }
                case "set": {
                    if (key == null) break;
                    String keyStr = key.getAsString();
                    if (CommandSettings.getSettings().containsKey(keyStr)) {
                        boolean newval;
                        if (ArrayUtils.contains(Configuration.instance().linking.settingsBlacklist, keyStr)) {
                            reply.thenAccept(c -> c.sendMessage(Localization.instance().personalSettings.settingUpdateBlocked).queue());
                            return;
                        }
                        PlayerLink link = LinkManager.getLink(ev.getUser().getId(), null);
                        try {
                            newval = value != null ? Boolean.parseBoolean(value.getAsString()) : false;
                        }
                        catch (NumberFormatException e) {
                            newval = false;
                        }
                        boolean newValue = newval;
                        try {
                            link.settings.getClass().getDeclaredField(keyStr).set(link, newValue);
                            LinkManager.addLink(link);
                        }
                        catch (IllegalAccessException | NoSuchFieldException e) {
                            e.printStackTrace();
                            reply.thenAccept(c -> c.sendMessage(Localization.instance().personalSettings.settingUpdateFailed).queue());
                        }
                        reply.thenAccept(c -> c.sendMessage(Localization.instance().personalSettings.settingUpdateSuccessful).queue());
                        break;
                    }
                    reply.thenAccept(c -> c.sendMessage(Localization.instance().personalSettings.invalidPersonalSettingKey.replace("%key%", keyStr)).queue());
                }
            }
        } else {
            DiscordIntegration.LOGGER.error("SUBCOMMAND == NULL");
        }
    }

    private static HashMap<String, String> getSettings() {
        HashMap<String, String> out = new HashMap<String, String>();
        Field[] fields = PlayerSettings.class.getFields();
        Field[] descFields = PlayerSettings.Descriptions.class.getDeclaredFields();
        for (Field f : fields) {
            out.put(f.getName(), "No Description Provided");
        }
        for (Field f : descFields) {
            f.setAccessible(true);
            try {
                out.put(f.getName(), (String)f.get(new PlayerSettings.Descriptions()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    @Override
    public boolean adminOnly() {
        return false;
    }
}

