/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.discordCommands;

import dcshadow.org.jetbrains.annotations.NotNull;
import dcshadow.org.json.JSONObject;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.DiscordCommand;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.PlayerLink;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import net.dv8tion.jda.api.utils.messages.MessageEditBuilder;

public class CommandLinkcheck
extends DiscordCommand {
    public CommandLinkcheck() {
        super("linkcheck", Localization.instance().commands.descriptions.linkcheck);
        this.addOption(OptionType.USER, "discorduser", Localization.instance().commands.cmdLinkcheck_userargDesc, false);
        this.addOption(OptionType.STRING, "mcplayer", Localization.instance().commands.cmdLinkcheck_mcargDesc, false);
    }

    @Override
    public void execute(SlashCommandInteractionEvent ev, ReplyCallbackAction replyCallbackAction) {
        CompletableFuture reply = replyCallbackAction.setEphemeral(true).submit();
        OptionMapping discorduser = ev.getOption("discorduser");
        OptionMapping mcplayer = ev.getOption("mcplayer");
        if (discorduser == null && mcplayer == null) {
            reply.thenAccept(i -> i.editOriginal(Localization.instance().commands.notEnoughArguments).queue());
        } else if (discorduser != null && mcplayer != null) {
            reply.thenAccept(i -> i.editOriginal(Localization.instance().commands.tooManyArguments).queue());
        } else if (discorduser != null) {
            if (LinkManager.isDiscordUserLinked(discorduser.getAsUser().getId())) {
                reply.thenAccept(i -> i.editOriginal(((MessageEditBuilder)new MessageEditBuilder().setEmbeds(this.buildEmbed(LinkManager.getLink(discorduser.getAsUser().getId(), null)))).build()).queue());
            } else {
                reply.thenAccept(i -> i.editOriginal(new MessageEditBuilder().setContent(Localization.instance().commands.cmdLinkcheck_notlinked).build()).queue());
            }
        } else {
            UUID uuid;
            try {
                uuid = UUID.fromString(mcplayer.getAsString().replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
            }
            catch (IllegalArgumentException e) {
                try {
                    JSONObject mc_json = CommandLinkcheck.getMcJson(mcplayer);
                    if (mc_json.has("error")) {
                        reply.thenAccept(i -> i.editOriginal(new MessageEditBuilder().setContent(Localization.instance().commands.cmdLinkcheck_cannotGetPlayer).build()).queue());
                    }
                    uuid = UUID.fromString(mc_json.getString("id").replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
                }
                catch (Exception er) {
                    er.printStackTrace();
                    reply.thenAccept(i -> i.editOriginal(new MessageEditBuilder().setContent(Localization.instance().commands.cmdLinkcheck_cannotGetPlayer).build()).queue());
                    return;
                }
            }
            if (LinkManager.isPlayerLinked(uuid)) {
                UUID Uuid = uuid;
                reply.thenAccept(i -> i.editOriginal(((MessageEditBuilder)new MessageEditBuilder().setEmbeds(this.buildEmbed(LinkManager.getLink(null, Uuid)))).build()).queue());
            } else {
                reply.thenAccept(i -> i.editOriginal(new MessageEditBuilder().setContent(Localization.instance().commands.cmdLinkcheck_notlinked).build()).queue());
            }
        }
    }

    @NotNull
    private static JSONObject getMcJson(OptionMapping mcplayer) throws IOException {
        int read;
        URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + mcplayer.getAsString().trim());
        URLConnection urlConnection = url.openConnection();
        urlConnection.addRequestProperty("User-Agent", "DiscordIntegration-by-ErdbeerbaerLP");
        urlConnection.addRequestProperty("Accept", "application/json");
        urlConnection.connect();
        BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        StringBuilder buffer = new StringBuilder();
        char[] chars = new char[1024];
        while ((read = reader.read(chars)) != -1) {
            buffer.append(chars, 0, read);
        }
        reader.close();
        JSONObject mc_json = new JSONObject(buffer.toString());
        return mc_json;
    }

    @Override
    public boolean adminOnly() {
        return true;
    }

    private MessageEmbed buildEmbed(PlayerLink link) {
        Member user = DiscordIntegration.INSTANCE.getMemberById(link.discordID);
        EmbedBuilder b = new EmbedBuilder();
        b.addField(Localization.instance().commands.cmdLinkcheck_discordAcc, user.getAsMention(), true);
        if (link.mcPlayerUUID != null && !link.mcPlayerUUID.isBlank()) {
            String mcname = DiscordIntegration.INSTANCE.getServerInterface().getNameFromUUID(UUID.fromString(link.mcPlayerUUID));
            b.addField(Localization.instance().commands.cmdLinkcheck_minecraftAcc, mcname + "\n" + link.mcPlayerUUID, true);
        }
        if (link.floodgateUUID != null && !link.floodgateUUID.isBlank()) {
            b.addField(Localization.instance().commands.cmdLinkcheck_minecraftAccFloodgate, link.floodgateUUID, true);
        }
        return b.build();
    }
}

