/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.com.moandjiezana.toml;

import dcshadow.com.moandjiezana.toml.CommentUtil;
import dcshadow.com.moandjiezana.toml.ObjectValueWriter;
import dcshadow.com.moandjiezana.toml.PrimitiveArrayValueWriter;
import dcshadow.com.moandjiezana.toml.TableArrayValueWriter;
import dcshadow.com.moandjiezana.toml.ValueWriter;
import dcshadow.com.moandjiezana.toml.ValueWriters;
import dcshadow.com.moandjiezana.toml.WriterContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MapValueWriter
implements ValueWriter {
    static final ValueWriter MAP_VALUE_WRITER = new MapValueWriter();
    private static final Pattern REQUIRED_QUOTING_PATTERN = Pattern.compile("^.*[^A-Za-z\\d_-].*$");

    private MapValueWriter() {
    }

    private static String quoteKey(Object key) {
        Object stringKey = key.toString();
        Matcher matcher = REQUIRED_QUOTING_PATTERN.matcher((CharSequence)stringKey);
        if (matcher.matches()) {
            stringKey = "\"" + (String)stringKey + "\"";
        }
        return stringKey;
    }

    private static boolean hasPrimitiveValues(Map<?, ?> values2, WriterContext context) {
        for (Object key : values2.keySet()) {
            ValueWriter valueWriter;
            Object fromValue = values2.get(key);
            if (fromValue == null || !(valueWriter = ValueWriters.WRITERS.findWriterFor(fromValue)).isPrimitiveType() && valueWriter != PrimitiveArrayValueWriter.PRIMITIVE_ARRAY_VALUE_WRITER) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrite(Object value) {
        return value instanceof Map;
    }

    @Override
    public void write(Object value, WriterContext context) {
        this.write(value, context, null, null, null);
    }

    public void write(Object value, WriterContext context, ArrayList<String[]> valueComments, ArrayList<String[]> objComments, String[] objectComment) {
        boolean hasComment;
        Map from = (Map)value;
        if (MapValueWriter.hasPrimitiveValues(from, context)) {
            context.writeKey(objectComment);
        }
        int comment = 0;
        for (Map.Entry entry : from.entrySet()) {
            Object key = entry.getKey();
            Object fromValue = entry.getValue();
            if (fromValue == null) continue;
            hasComment = valueComments != null && !valueComments.isEmpty() && valueComments.size() > comment && valueComments.get(comment) != null;
            ValueWriter valueWriter = ValueWriters.WRITERS.findWriterFor(fromValue);
            if (hasComment && valueWriter != ObjectValueWriter.OBJECT_VALUE_WRITER) {
                CommentUtil.addComments(valueComments.get(comment), context);
            }
            if (valueWriter.isPrimitiveType()) {
                context.indent();
                context.write(MapValueWriter.quoteKey(key)).write(" = ");
                valueWriter.write(fromValue, context);
                context.write('\n');
            } else if (valueWriter == PrimitiveArrayValueWriter.PRIMITIVE_ARRAY_VALUE_WRITER) {
                context.setArrayKey(key.toString());
                context.write(MapValueWriter.quoteKey(key)).write(" = ");
                valueWriter.write(fromValue, context);
                context.write('\n');
            }
            ++comment;
        }
        comment = 0;
        for (Map.Entry key : from.keySet()) {
            Object fromValue = from.get(key);
            if (fromValue == null) continue;
            ValueWriter valueWriter = ValueWriters.WRITERS.findWriterFor(fromValue);
            if (valueWriter == this || valueWriter == TableArrayValueWriter.TABLE_ARRAY_VALUE_WRITER) {
                valueWriter.write(fromValue, context.pushTable(MapValueWriter.quoteKey(key)));
                continue;
            }
            if (valueWriter != ObjectValueWriter.OBJECT_VALUE_WRITER) continue;
            hasComment = objComments != null && !objComments.isEmpty() && objComments.size() > comment && objComments.get(comment) != null;
            ((ObjectValueWriter)valueWriter).write(fromValue, context.pushTable(MapValueWriter.quoteKey(key)), hasComment ? objComments.get(comment) : null);
            ++comment;
        }
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }
}

