/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.quarry.Target;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DigTarget
extends Target {
    final Area area;
    final int y;
    @Nullable
    private BlockPos.MutableBlockPos currentTarget;

    DigTarget(Area area, int y) {
        this.area = area;
        this.y = y;
        int x = y % 2 == 0 ? area.minX() + 1 : area.maxX() - 1;
        this.currentTarget = new BlockPos.MutableBlockPos(x, y, DigTarget.initZ(x, this.y, area.minZ() + 1, area.maxZ() - 1));
    }

    @Override
    @Nullable
    public BlockPos get(boolean goNext) {
        if (this.currentTarget == null) {
            return null;
        }
        BlockPos pre = this.currentTarget.m_7949_();
        if (goNext) {
            int nextZ;
            int n = nextZ = pre.m_123341_() % 2 == 0 ^ this.y % 2 == 0 ? pre.m_123343_() + 1 : pre.m_123343_() - 1;
            if (this.area.minZ() < nextZ && nextZ < this.area.maxZ()) {
                this.currentTarget.m_122178_(pre.m_123341_(), pre.m_123342_(), nextZ);
            } else {
                int nextX;
                int n2 = nextX = this.y % 2 == 0 ? pre.m_123341_() + 1 : pre.m_123341_() - 1;
                if (this.area.minX() < nextX && nextX < this.area.maxX()) {
                    this.currentTarget.m_122178_(nextX, pre.m_123342_(), DigTarget.initZ(nextX, this.y, this.area.minZ() + 1, this.area.maxZ() - 1));
                } else {
                    this.currentTarget = null;
                    return null;
                }
            }
        }
        return pre;
    }

    @Override
    @NotNull
    public Stream<BlockPos> allPoses() {
        return BlockPos.m_121886_((int)this.area.minX(), (int)this.y, (int)this.area.minZ(), (int)this.area.maxX(), (int)this.y, (int)this.area.maxZ());
    }

    @Override
    @NotNull
    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("area", (Tag)this.area.toNBT());
        tag.m_128405_("y", this.y);
        if (this.currentTarget != null) {
            tag.m_128356_("currentTarget", this.currentTarget.m_121878_());
        }
        return tag;
    }

    @Override
    public double progress() {
        if (this.currentTarget == null) {
            return 1.0;
        }
        double xUnit = 1.0 / (double)(this.area.maxX() - this.area.minX() - 1);
        double xProgress = this.y % 2 == 0 ? xUnit * (double)(this.currentTarget.m_123341_() - this.area.minX() - 1) : xUnit * (double)(this.area.maxX() - this.currentTarget.m_123341_() - 1);
        return xProgress;
    }

    static DigTarget from(CompoundTag tag) {
        DigTarget target = new DigTarget(Area.fromNBT(tag.m_128469_("area")).orElseThrow(), tag.m_128451_("y"));
        if (tag.m_128441_("currentTarget")) {
            assert (target.currentTarget != null);
            target.currentTarget.m_122188_(tag.m_128454_("currentTarget"));
        } else {
            target.currentTarget = null;
        }
        return target;
    }

    static int initZ(int x, int y, int minZ, int maxZ) {
        return x % 2 == 0 ^ y % 2 == 0 ? minZ : maxZ;
    }

    public String toString() {
        return "DigTarget{area=" + this.area + ", y=" + this.y + ", currentTarget=" + this.currentTarget + "}";
    }
}

