/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryItem;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryTile;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class MiniQuarryBlock
extends QPBlock
implements EntityBlock {
    public static final String NAME = "mini_quarry";

    public MiniQuarryBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.5f, 10.0f).m_60918_(SoundType.f_56742_), NAME, MiniQuarryItem::new);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return Holder.MINI_QUARRY_TYPE.m_155264_(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WORKING, BlockStateProperties.f_61372_});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.m_49954_()}), true);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!player.m_6144_()) {
            if (!level.f_46443_) {
                level.m_141902_(pos, Holder.MINI_QUARRY_TYPE).ifPresent(t -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)t, (BlockPos)pos));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_43723_() == null ? Direction.NORTH : ctx.m_43723_().m_6350_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing);
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (!level.f_46443_ && !this.disallowedDim().contains(level.m_46472_().m_135782_())) {
            level.m_141902_(pos, Holder.MINI_QUARRY_TYPE).ifPresent(t -> {
                t.setEnchantments(EnchantmentLevel.fromItem(stack));
                boolean preForced = QuarryChunkLoadUtil.makeChunkLoaded(level, pos, t.enabled);
                t.setChunkPreLoaded(preForced);
            });
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
        if (!level.f_46443_) {
            boolean powered = level.m_46753_(pos);
            level.m_141902_(pos, Holder.MINI_QUARRY_TYPE).ifPresent(t -> {
                if (powered && !t.rs) {
                    t.gotRSPulse();
                }
                t.rs = powered;
            });
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MiniQuarryTile) {
                MiniQuarryTile tile = (MiniQuarryTile)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)tile.getInv());
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, moved);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : MiniQuarryBlock.checkType(blockEntityType, Holder.MINI_QUARRY_TYPE, CombinedBlockEntityTicker.of(this, level, PowerTile.getGenerator(), (w, p, s, t) -> t.work(), PowerTile.logTicker()));
    }
}

