/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.mojang.datafixers.DSL;
import com.yogpc.qp.QuarryCreativeTab;
import com.yogpc.qp.machines.EnchantedLootFunction;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.QPItem;
import com.yogpc.qp.machines.advpump.AdvPumpMenu;
import com.yogpc.qp.machines.advpump.BlockAdvPump;
import com.yogpc.qp.machines.advpump.TileAdvPump;
import com.yogpc.qp.machines.advquarry.AdvQuarryMenu;
import com.yogpc.qp.machines.advquarry.BlockAdvQuarry;
import com.yogpc.qp.machines.advquarry.TileAdvQuarry;
import com.yogpc.qp.machines.bookmover.BookMoverBlock;
import com.yogpc.qp.machines.bookmover.BookMoverEntity;
import com.yogpc.qp.machines.bookmover.BookMoverMenu;
import com.yogpc.qp.machines.checker.ItemChecker;
import com.yogpc.qp.machines.controller.BlockController;
import com.yogpc.qp.machines.filler.FillerBlock;
import com.yogpc.qp.machines.filler.FillerEntity;
import com.yogpc.qp.machines.filler.FillerMenu;
import com.yogpc.qp.machines.marker.BlockExMarker;
import com.yogpc.qp.machines.marker.BlockMarker;
import com.yogpc.qp.machines.marker.BlockWaterloggedMarker;
import com.yogpc.qp.machines.marker.ContainerMarker;
import com.yogpc.qp.machines.marker.Tile16Marker;
import com.yogpc.qp.machines.marker.TileFlexMarker;
import com.yogpc.qp.machines.marker.TileMarker;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryBlock;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryMenu;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryTile;
import com.yogpc.qp.machines.miningwell.MiningWellBlock;
import com.yogpc.qp.machines.miningwell.MiningWellTile;
import com.yogpc.qp.machines.misc.BlockDummy;
import com.yogpc.qp.machines.misc.CreativeGeneratorBlock;
import com.yogpc.qp.machines.misc.CreativeGeneratorMenu;
import com.yogpc.qp.machines.misc.CreativeGeneratorTile;
import com.yogpc.qp.machines.misc.YSetterContainer;
import com.yogpc.qp.machines.misc.YSetterItem;
import com.yogpc.qp.machines.module.BedrockModuleItem;
import com.yogpc.qp.machines.module.ContainerQuarryModule;
import com.yogpc.qp.machines.module.EnergyModuleItem;
import com.yogpc.qp.machines.module.ExpModuleItem;
import com.yogpc.qp.machines.module.ExpPumpBlock;
import com.yogpc.qp.machines.module.ExpPumpTile;
import com.yogpc.qp.machines.module.FillerModuleItem;
import com.yogpc.qp.machines.module.FilterModuleItem;
import com.yogpc.qp.machines.module.FilterModuleMenu;
import com.yogpc.qp.machines.module.ModuleLootFunction;
import com.yogpc.qp.machines.module.PumpModuleItem;
import com.yogpc.qp.machines.module.PumpPlusBlock;
import com.yogpc.qp.machines.module.RepeatTickModuleItem;
import com.yogpc.qp.machines.module.ReplacerBlock;
import com.yogpc.qp.machines.module.ReplacerDummyBlock;
import com.yogpc.qp.machines.module.ReplacerModuleItem;
import com.yogpc.qp.machines.mover.BlockMover;
import com.yogpc.qp.machines.mover.ContainerMover;
import com.yogpc.qp.machines.placer.PlacerBlock;
import com.yogpc.qp.machines.placer.PlacerContainer;
import com.yogpc.qp.machines.placer.PlacerTile;
import com.yogpc.qp.machines.placer.RemotePlacerBlock;
import com.yogpc.qp.machines.placer.RemotePlacerTile;
import com.yogpc.qp.machines.quarry.FrameBlock;
import com.yogpc.qp.machines.quarry.QuarryBlock;
import com.yogpc.qp.machines.quarry.QuarryLootFunction;
import com.yogpc.qp.machines.quarry.SFQuarryBlock;
import com.yogpc.qp.machines.quarry.SFQuarryEntity;
import com.yogpc.qp.machines.quarry.SFQuarryMenu;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.machines.workbench.BlockWorkbench;
import com.yogpc.qp.machines.workbench.ContainerWorkbench;
import com.yogpc.qp.machines.workbench.TileWorkbench;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.RegisterEvent;

public class Holder {
    public static final CreativeModeTab TAB = new QuarryCreativeTab();
    private static final List<QPBlock> BLOCKS = new ArrayList<QPBlock>();
    private static final List<QPItem> ITEMS = new ArrayList<QPItem>();
    private static final List<NamedEntry<BlockEntityType<?>>> ENTITY_TYPES = new ArrayList();
    private static final List<NamedEntry<MenuType<?>>> MENU_TYPES = new ArrayList();
    private static final List<EntryConditionHolder> CONDITION_HOLDERS = new ArrayList<EntryConditionHolder>();
    public static final QuarryBlock BLOCK_QUARRY = Holder.registerBlock(new QuarryBlock());
    public static final SFQuarryBlock BLOCK_SOLID_FUEL_QUARRY = Holder.registerBlock(new SFQuarryBlock());
    public static final BlockWorkbench BLOCK_WORKBENCH = Holder.registerBlock(new BlockWorkbench());
    public static final MiningWellBlock BLOCK_MINING_WELL = Holder.registerBlock(new MiningWellBlock());
    public static final BlockMover BLOCK_MOVER = Holder.registerBlock(new BlockMover(), EnableOrNot.CONFIG_ON);
    public static final BookMoverBlock BLOCK_BOOK_MOVER = Holder.registerBlock(new BookMoverBlock());
    public static final PumpPlusBlock BLOCK_PUMP = Holder.registerBlock(new PumpPlusBlock(), EnableOrNot.CONFIG_ON);
    public static final ReplacerBlock BLOCK_REPLACER = Holder.registerBlock(new ReplacerBlock(), EnableOrNot.CONFIG_OFF);
    public static final ExpPumpBlock BLOCK_EXP_PUMP = Holder.registerBlock(new ExpPumpBlock());
    public static final BlockAdvPump BLOCK_ADV_PUMP = Holder.registerBlock(new BlockAdvPump());
    public static final BlockAdvQuarry BLOCK_ADV_QUARRY = Holder.registerBlock(new BlockAdvQuarry());
    public static final MiniQuarryBlock BLOCK_MINI_QUARRY = Holder.registerBlock(new MiniQuarryBlock());
    public static final FillerBlock BLOCK_FILLER = Holder.registerBlock(new FillerBlock());
    public static final BlockMarker BLOCK_MARKER = Holder.registerBlock(new BlockMarker());
    public static final BlockExMarker.BlockFlexMarker BLOCK_FLEX_MARKER = Holder.registerBlock(new BlockExMarker.BlockFlexMarker());
    public static final BlockExMarker.Block16Marker BLOCK_16_MARKER = Holder.registerBlock(new BlockExMarker.Block16Marker());
    public static final BlockWaterloggedMarker BLOCK_WATERLOGGED_MARKER = Holder.registerBlock(new BlockWaterloggedMarker());
    public static final BlockExMarker.BlockWaterloggedFlexMarker BLOCK_WATERLOGGED_FLEX_MARKER = Holder.registerBlock(new BlockExMarker.BlockWaterloggedFlexMarker());
    public static final BlockExMarker.BlockWaterlogged16Marker BLOCK_WATERLOGGED_16_MARKER = Holder.registerBlock(new BlockExMarker.BlockWaterlogged16Marker());
    public static final PlacerBlock BLOCK_PLACER = Holder.registerBlock(new PlacerBlock());
    public static final RemotePlacerBlock BLOCK_REMOTE_PLACER = Holder.registerBlock(new RemotePlacerBlock());
    public static final BlockController BLOCK_CONTROLLER = Holder.registerBlock(new BlockController(), EnableOrNot.CONFIG_OFF);
    public static final FrameBlock BLOCK_FRAME = Holder.registerBlock(new FrameBlock(), EnableOrNot.ALWAYS_ON);
    public static final BlockDummy BLOCK_DUMMY = new BlockDummy();
    public static final ReplacerDummyBlock BLOCK_DUMMY_REPLACER = new ReplacerDummyBlock();
    public static final CreativeGeneratorBlock BLOCK_CREATIVE_GENERATOR = Holder.registerBlock(new CreativeGeneratorBlock());
    public static final ItemChecker ITEM_CHECKER = Holder.registerItem(new ItemChecker(), EnableOrNot.ALWAYS_ON);
    public static final YSetterItem ITEM_Y_SETTER = Holder.registerItem(new YSetterItem(), EnableOrNot.ALWAYS_ON);
    public static final PumpModuleItem ITEM_PUMP_MODULE = Holder.registerItem(new PumpModuleItem(), EnableOrNot.CONFIG_ON);
    public static final ReplacerModuleItem ITEM_REPLACER_MODULE = Holder.registerItem(new ReplacerModuleItem(), EnableOrNot.CONFIG_OFF);
    public static final ExpModuleItem ITEM_EXP_MODULE = Holder.registerItem(new ExpModuleItem(), EnableOrNot.CONFIG_ON);
    public static final BedrockModuleItem ITEM_BEDROCK_MODULE = Holder.registerItem(new BedrockModuleItem(), EnableOrNot.CONFIG_OFF);
    public static final EnergyModuleItem ITEM_FUEL_MODULE_NORMAL = Holder.registerItem(new EnergyModuleItem(5, "fuel_module_normal"), EnableOrNot.CONFIG_ON);
    public static final FillerModuleItem ITEM_FILLER_MODULE = Holder.registerItem(new FillerModuleItem(), EnableOrNot.CONFIG_OFF);
    public static final FilterModuleItem ITEM_FILTER_MODULE = Holder.registerItem(new FilterModuleItem(), EnableOrNot.CONFIG_ON);
    public static final RepeatTickModuleItem ITEM_REPEAT_MODULE = Holder.registerItem(new RepeatTickModuleItem(), EnableOrNot.CONFIG_OFF);
    public static final BlockEntityType<TileQuarry> QUARRY_TYPE = Holder.registerEntityType(TileQuarry::new, BLOCK_QUARRY, EnableOrNot.CONFIG_ON);
    public static final BlockEntityType<SFQuarryEntity> SOLID_FUEL_QUARRY_TYPE = Holder.registerEntityType(SFQuarryEntity::new, BLOCK_SOLID_FUEL_QUARRY, EnableOrNot.CONFIG_ON);
    public static final BlockEntityType<TileMarker> MARKER_TYPE = Holder.registerEntityType(TileMarker::new, List.of(BLOCK_MARKER, BLOCK_WATERLOGGED_MARKER), EnableOrNot.ALWAYS_ON);
    public static final BlockEntityType<TileFlexMarker> FLEX_MARKER_TYPE = Holder.registerEntityType(TileFlexMarker::new, List.of(BLOCK_FLEX_MARKER, BLOCK_WATERLOGGED_FLEX_MARKER), EnableOrNot.ALWAYS_ON);
    public static final BlockEntityType<Tile16Marker> MARKER_16_TYPE = Holder.registerEntityType(Tile16Marker::new, List.of(BLOCK_16_MARKER, BLOCK_WATERLOGGED_16_MARKER), EnableOrNot.ALWAYS_ON);
    public static final BlockEntityType<CreativeGeneratorTile> CREATIVE_GENERATOR_TYPE = Holder.registerEntityType(CreativeGeneratorTile::new, BLOCK_CREATIVE_GENERATOR, EnableOrNot.ALWAYS_ON);
    public static final BlockEntityType<TileAdvPump> ADV_PUMP_TYPE = Holder.registerEntityType(TileAdvPump::new, BLOCK_ADV_PUMP, EnableOrNot.CONFIG_ON);
    public static final BlockEntityType<TileAdvQuarry> ADV_QUARRY_TYPE = Holder.registerEntityType(TileAdvQuarry::new, BLOCK_ADV_QUARRY, EnableOrNot.CONFIG_ON);
    public static final BlockEntityType<TileWorkbench> WORKBENCH_TYPE = Holder.registerEntityType(TileWorkbench::new, BLOCK_WORKBENCH, EnableOrNot.CONFIG_ON);
    public static final BlockEntityType<MiningWellTile> MINING_WELL_TYPE = Holder.registerEntityType(MiningWellTile::new, BLOCK_MINING_WELL, EnableOrNot.CONFIG_ON);
    public static final BlockEntityType<ExpPumpTile> EXP_PUMP_TYPE = Holder.registerEntityType(ExpPumpTile::new, BLOCK_EXP_PUMP, EnableOrNot.CONFIG_ON);
    public static final BlockEntityType<PlacerTile> PLACER_TYPE = Holder.registerEntityType(PlacerTile::new, BLOCK_PLACER, EnableOrNot.CONFIG_ON);
    public static final BlockEntityType<RemotePlacerTile> REMOTE_PLACER_TYPE = Holder.registerEntityType(RemotePlacerTile::new, BLOCK_REMOTE_PLACER, EnableOrNot.CONFIG_OFF);
    public static final BlockEntityType<BookMoverEntity> BOOK_MOVER_TYPE = Holder.registerEntityType(BookMoverEntity::new, BLOCK_BOOK_MOVER, EnableOrNot.CONFIG_OFF);
    public static final BlockEntityType<MiniQuarryTile> MINI_QUARRY_TYPE = Holder.registerEntityType(MiniQuarryTile::new, BLOCK_MINI_QUARRY, EnableOrNot.CONFIG_ON);
    public static final BlockEntityType<FillerEntity> FILLER_TYPE = Holder.registerEntityType(FillerEntity::new, BLOCK_FILLER, EnableOrNot.CONFIG_ON);
    public static final MenuType<ContainerMarker> FLEX_MARKER_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new ContainerMarker(windowId, inv.f_35978_, data.m_130135_(), FLEX_MARKER_MENU_TYPE, 29, 139), "quarryplus:gui_flex_marker");
    public static final MenuType<ContainerMarker> MARKER_16_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new ContainerMarker(windowId, inv.f_35978_, data.m_130135_(), MARKER_16_MENU_TYPE, 29, 107), "quarryplus:gui_marker16");
    public static final MenuType<YSetterContainer> Y_SETTER_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new YSetterContainer(windowId, inv.f_35978_, data.m_130135_()), "quarryplus:gui_y_setter");
    public static final MenuType<ContainerWorkbench> WORKBENCH_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new ContainerWorkbench(windowId, inv.f_35978_, data.m_130135_()), "quarryplus:gui_workbench");
    public static final MenuType<ContainerMover> MOVER_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new ContainerMover(windowId, inv.f_35978_, data.m_130135_()), "quarryplus:gui_mover");
    public static final MenuType<ContainerQuarryModule> MODULE_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new ContainerQuarryModule(windowId, inv.f_35978_, data.m_130135_()), "quarryplus:gui_quarry_module");
    public static final MenuType<PlacerContainer> PLACER_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new PlacerContainer(windowId, inv.f_35978_, data.m_130135_(), PlacerTile.class), "quarryplus:gui_placer_plus");
    public static final MenuType<PlacerContainer> REMOTE_PLACER_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new PlacerContainer(windowId, inv.f_35978_, data.m_130135_(), RemotePlacerTile.class), "quarryplus:gui_remote_placer");
    public static final MenuType<BookMoverMenu> BOOK_MOVER_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new BookMoverMenu(windowId, inv.f_35978_, data.m_130135_()), "quarryplus:gui_book_mover");
    public static final MenuType<CreativeGeneratorMenu> CREATIVE_GENERATOR_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new CreativeGeneratorMenu(windowId, inv.f_35978_, data.m_130135_()), "quarryplus:gui_creative_generator");
    public static final MenuType<AdvQuarryMenu> ADV_QUARRY_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new AdvQuarryMenu(windowId, inv.f_35978_, data.m_130135_()), "quarryplus:gui_adv_quarry");
    public static final MenuType<MiniQuarryMenu> MINI_QUARRY_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new MiniQuarryMenu(windowId, inv.f_35978_, data.m_130135_()), "quarryplus:gui_mini_quarry");
    public static final MenuType<SFQuarryMenu> SOLID_FUEL_QUARRY_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new SFQuarryMenu(windowId, inv.f_35978_, data.m_130135_()), "quarryplus:gui_solid_fuel_quarry");
    public static final MenuType<FillerMenu> FILLER_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new FillerMenu(windowId, inv.f_35978_, data.m_130135_()), "quarryplus:gui_filler");
    public static final MenuType<FilterModuleMenu> FILTER_MODULE_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new FilterModuleMenu(windowId, inv.f_35978_, inv.m_8020_(inv.f_35977_)), "quarryplus:gui_filter_module");
    public static final MenuType<AdvPumpMenu> ADV_PUMP_MENU_TYPE = Holder.registerMenuType((windowId, inv, data) -> new AdvPumpMenu(windowId, inv.f_35978_, data.m_130135_()), "quarryplus:gui_adv_pump");
    public static final LootItemFunctionType ENCHANTED_LOOT_TYPE = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation("quarryplus", "drop_function"), (Object)new LootItemFunctionType(EnchantedLootFunction.SERIALIZER));
    public static final LootItemFunctionType QUARRY_LOOT_TYPE = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation("quarryplus", "drop_function_quarry"), (Object)new LootItemFunctionType(QuarryLootFunction.SERIALIZER));
    public static final LootItemFunctionType MODULE_LOOT_TYPE = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation("quarryplus", "drop_function_module"), (Object)new LootItemFunctionType(ModuleLootFunction.SERIALIZER));
    public static final TagKey<Item> TAG_MARKERS = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("quarryplus", "markers"));

    private static <T extends QPBlock> T registerBlock(T block, EnableOrNot condition) {
        BLOCKS.add(block);
        CONDITION_HOLDERS.add(new EntryConditionHolder(block.getRegistryName(), condition));
        ((QuarryCreativeTab)TAB).addItem((ItemLike)block);
        return block;
    }

    private static <T extends QPBlock> T registerBlock(T block) {
        BLOCKS.add(block);
        ((QuarryCreativeTab)TAB).addItem((ItemLike)block);
        return block;
    }

    private static <T extends QPItem> T registerItem(T item, EnableOrNot condition) {
        ITEMS.add(item);
        CONDITION_HOLDERS.add(new EntryConditionHolder(item.getRegistryName(), condition));
        ((QuarryCreativeTab)TAB).addItem((ItemLike)item);
        return item;
    }

    private static <T extends BlockEntity> BlockEntityType<T> registerEntityType(BlockEntityType.BlockEntitySupplier<T> supplier, QPBlock block, EnableOrNot condition) {
        return Holder.registerEntityType(supplier, List.of(block), condition);
    }

    private static <T extends BlockEntity> BlockEntityType<T> registerEntityType(BlockEntityType.BlockEntitySupplier<T> supplier, List<QPBlock> block, EnableOrNot condition) {
        if (block.isEmpty()) {
            throw new IllegalArgumentException("Blocks must not be empty.");
        }
        BlockEntityType type = BlockEntityType.Builder.m_155273_(supplier, (Block[])((Block[])block.toArray(Block[]::new))).m_58966_(DSL.emptyPartType());
        ENTITY_TYPES.add(new NamedEntry<BlockEntityType>(block.get(0).getRegistryName(), type));
        CONDITION_HOLDERS.add(new EntryConditionHolder(block.get(0).getRegistryName(), condition));
        return type;
    }

    private static <T extends AbstractContainerMenu> MenuType<T> registerMenuType(IContainerFactory<T> factory, String guiId) {
        MenuType type = IForgeMenuType.create(factory);
        MENU_TYPES.add(new NamedEntry<MenuType>(new ResourceLocation(guiId), type));
        return type;
    }

    public static List<NamedEntry<QPBlock>> blocks() {
        return BLOCKS.stream().map(q -> new NamedEntry<QPBlock>(q.getRegistryName(), (QPBlock)((Object)q))).toList();
    }

    public static List<NamedEntry<? extends Item>> items() {
        return Stream.concat(BLOCKS.stream().map(q -> new NamedEntry<BlockItem>(q.getRegistryName(), q.blockItem)), ITEMS.stream().map(i -> new NamedEntry<QPItem>(i.getRegistryName(), (QPItem)((Object)i)))).toList();
    }

    public static List<NamedEntry<BlockEntityType<?>>> entityTypes() {
        return Collections.unmodifiableList(ENTITY_TYPES);
    }

    public static List<EntryConditionHolder> conditionHolders() {
        return Collections.unmodifiableList(CONDITION_HOLDERS);
    }

    public static List<NamedEntry<MenuType<?>>> menuTypes() {
        return Collections.unmodifiableList(MENU_TYPES);
    }

    public record EntryConditionHolder(ResourceLocation location, EnableOrNot condition) {
        public boolean configurable() {
            return this.condition.configurable();
        }

        public String path() {
            return this.location.m_135815_();
        }
    }

    public static enum EnableOrNot {
        CONFIG_ON,
        CONFIG_OFF,
        ALWAYS_ON;


        public boolean configurable() {
            return this == CONFIG_ON || this == CONFIG_OFF;
        }

        public boolean on() {
            return this == CONFIG_ON || this == ALWAYS_ON;
        }
    }

    public record NamedEntry<T>(ResourceLocation name, T t) {
        public static <T> Consumer<? super NamedEntry<? extends T>> register(RegisterEvent.RegisterHelper<T> helper) {
            return e -> helper.register(e.name(), e.t());
        }
    }
}

