/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt.cache;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import journeymap.common.nbt.cache.CacheFileStorage;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.util.thread.StrictQueue;
import net.minecraft.world.level.ChunkPos;

public class CacheWorker
implements AutoCloseable {
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final ProcessorMailbox<StrictQueue.IntRunnable> mailbox;
    private final CacheFileStorage storage;
    private final Map<ChunkPos, PendingStore> pendingWrites = Maps.newLinkedHashMap();

    protected CacheWorker(Path path, boolean async) {
        this.storage = new CacheFileStorage(path, async);
        this.mailbox = new ProcessorMailbox((StrictQueue)new StrictQueue.FixedPriorityQueue(Priority.values().length), (Executor)Util.m_183992_(), "JM-Cache");
    }

    public CompletableFuture<Void> store(ChunkPos chunkPos, @Nullable CompoundTag tag) {
        return this.submitTask(() -> {
            PendingStore pendingStore = this.pendingWrites.computeIfAbsent(chunkPos, func -> new PendingStore(tag));
            pendingStore.data = tag;
            return Either.left(pendingStore.result);
        }).thenCompose(Function.identity());
    }

    @Nullable
    public CompoundTag load(ChunkPos chunkPos) throws IOException {
        CompletableFuture<CompoundTag> future = this.loadAsync(chunkPos);
        try {
            return future.join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    protected CompletableFuture<CompoundTag> loadAsync(ChunkPos chunkPos) {
        return this.submitTask(() -> {
            PendingStore store = this.pendingWrites.get(chunkPos);
            if (store != null) {
                return Either.left((Object)store.data);
            }
            try {
                CompoundTag compoundtag = this.storage.read(chunkPos);
                return Either.left((Object)compoundtag);
            }
            catch (Exception e) {
                return Either.right((Object)e);
            }
        });
    }

    public CompletableFuture<Void> synchronize(boolean sync) {
        CompletionStage future = this.submitTask(() -> Either.left(CompletableFuture.allOf((CompletableFuture[])this.pendingWrites.values().stream().map(pendingStore -> pendingStore.result).toArray(CompletableFuture[]::new)))).thenCompose(Function.identity());
        return sync ? ((CompletableFuture)future).thenCompose(func -> this.submitTask(() -> {
            try {
                this.storage.flush();
                return Either.left(null);
            }
            catch (Exception e) {
                return Either.right((Object)e);
            }
        })) : ((CompletableFuture)future).thenCompose(func -> this.submitTask(() -> Either.left(null)));
    }

    private <T> CompletableFuture<T> submitTask(Supplier<Either<T, Exception>> supplier) {
        return this.mailbox.m_18722_(processorHandle -> new StrictQueue.IntRunnable(Priority.FOREGROUND.ordinal(), () -> this.lambda$submitTask$10(processorHandle, (Supplier)supplier)));
    }

    private void storePendingChunk() {
        if (!this.pendingWrites.isEmpty()) {
            Iterator<Map.Entry<ChunkPos, PendingStore>> iterator2 = this.pendingWrites.entrySet().iterator();
            Map.Entry<ChunkPos, PendingStore> entry = iterator2.next();
            iterator2.remove();
            this.runStore(entry.getKey(), entry.getValue());
            this.tellStorePending();
        }
    }

    private void tellStorePending() {
        this.mailbox.m_6937_((Object)new StrictQueue.IntRunnable(Priority.BACKGROUND.ordinal(), this::storePendingChunk));
    }

    private void runStore(ChunkPos pos, PendingStore store) {
        try {
            this.storage.write(pos, store.data);
            store.result.complete(null);
        }
        catch (Exception e) {
            store.result.completeExceptionally(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.shutdownRequested.compareAndSet(false, true)) {
            this.mailbox.m_18720_(processorHandle -> new StrictQueue.IntRunnable(Priority.SHUTDOWN.ordinal(), () -> processorHandle.m_6937_((Object)Unit.INSTANCE))).join();
            this.mailbox.close();
            try {
                this.storage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private /* synthetic */ void lambda$submitTask$10(ProcessorHandle processorHandle, Supplier supplier) {
        if (!this.shutdownRequested.get()) {
            processorHandle.m_6937_((Object)((Either)supplier.get()));
        }
        this.tellStorePending();
    }

    static enum Priority {
        FOREGROUND,
        BACKGROUND,
        SHUTDOWN;

    }

    static class PendingStore {
        @Nullable
        CompoundTag data;
        final CompletableFuture<Void> result = new CompletableFuture();

        public PendingStore(@Nullable CompoundTag data) {
            this.data = data;
        }
    }
}

