/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.Scrollable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ScrollPane
extends ObjectSelectionList<ScrollPaneEntry> {
    public int paneWidth = 0;
    public int paneHeight = 0;
    public Point2D.Double origin = new Point2D.Double();
    protected Scrollable f_93400_ = null;
    private Integer frameColor = new Color(-6250336).getRGB();
    private Minecraft mc;
    private int _mouseX;
    private int _mouseY;
    private boolean showFrame = true;
    private int firstVisibleIndex;
    private int lastVisibleIndex;
    private boolean drawPartialScrollable = true;
    private boolean renderSolidBackground = false;
    private boolean renderDecorations = true;
    private boolean scrollVisible = true;

    public ScrollPane(JmUI parent, Minecraft mc, int width, int height, List<? extends Scrollable> items, int itemHeight, int itemGap) {
        super(mc, width, height, 16, height, itemHeight + itemGap);
        for (Scrollable scrollable : items) {
            super.m_7085_((AbstractSelectionList.Entry)new ScrollPaneEntry(this, scrollable));
        }
        this.paneWidth = width;
        this.paneHeight = height;
        this.mc = mc;
    }

    public int getX() {
        return (int)this.origin.getX();
    }

    public int getY() {
        return (int)this.origin.getY();
    }

    public int getSlotHeight() {
        return this.f_93389_;
    }

    public void setDrawPartialScrollable(boolean value) {
        this.drawPartialScrollable = value;
    }

    public void setDimensions(int width, int height, int marginTop, int marginBottom, int x, int y) {
        super.m_93437_(width, height, y, y + height);
        this.paneWidth = width;
        this.paneHeight = height;
        this.origin.setLocation(x, y);
        this.m_93507_(x);
    }

    protected int m_5773_() {
        return super.m_5773_();
    }

    protected ScrollPaneEntry getEntry(int index) {
        return (ScrollPaneEntry)super.m_93500_(index);
    }

    public boolean m_7987_(int i) {
        return super.m_7987_(i);
    }

    public Button mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (ScrollPaneEntry entry : super.m_6702_()) {
                Scrollable item = entry.item;
                if (item == null || !this.inFullView(item)) continue;
                if (item instanceof Button) {
                    Button button = (Button)item;
                    if (!button.isHovered() || !button.m_6375_(mouseX, mouseY, mouseButton)) continue;
                    button.m_5691_();
                    return button;
                }
                item.clickScrollable(this.mc, mouseX, mouseY);
            }
        }
        return null;
    }

    public Button getButton(int mouseX, int mouseY) {
        for (ScrollPaneEntry entry : super.m_6702_()) {
            Button button;
            Scrollable item = entry.item;
            if (item == null || !this.inFullView(item) || !(item instanceof Button) || !(button = (Button)item).isHovered() || !button.mouseOver(mouseX, mouseY)) continue;
            return button;
        }
        return null;
    }

    public void m_6305_(PoseStack poseStack, int mX, int mY, float partialTicks) {
        this._mouseX = mX;
        this._mouseY = mY;
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
        super.m_93488_(false);
        super.m_93496_(false);
        poseStack.m_85836_();
        RenderWrapper.enableDepthTest();
        super.m_6305_(poseStack, mX, mY, partialTicks);
        poseStack.m_85849_();
    }

    protected void m_7733_(PoseStack poseStack) {
        int width = this.getWidth();
        float alpha = 0.4f;
        DrawUtil.drawRectangle(poseStack, this.getX(), this.getY(), width, this.paneHeight, Color.BLACK.getRGB(), this.renderSolidBackground ? 1.0f : alpha);
        boolean bl = this.scrollVisible = 0 < this.m_93518_();
        if (this.scrollVisible) {
            DrawUtil.drawRectangle(poseStack, this.getX() + width - 6, this.f_93390_, 5.0, this.paneHeight, Color.BLACK.getRGB(), alpha);
        }
        if (this.showFrame) {
            alpha = 1.0f;
            DrawUtil.drawRectangle(poseStack, this.getX() - 1, this.getY() - 1, width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(poseStack, this.getX() - 1, this.getY() + this.paneHeight, width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(poseStack, this.getX() - 1, this.getY() - 1, 1.0, this.paneHeight + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(poseStack, width + (this.scrollVisible ? 1 : 0) + this.getX(), this.getY() - 1, 1.0, this.paneHeight + 2, this.frameColor, alpha);
        }
    }

    public void renderItem(PoseStack poseStack, int index, int y, int x, int l, int var6, int var7, float f) {
        if (this.firstVisibleIndex == -1) {
            this.firstVisibleIndex = index;
        }
        this.lastVisibleIndex = Math.max(this.lastVisibleIndex, index);
        int margin = 4;
        int itemX = this.getX() + 2;
        Scrollable item = ((ScrollPaneEntry)super.m_93500_((int)index)).item;
        item.setPosition(itemX, y);
        item.setScrollableWidth(this.paneWidth - 4);
        if (this.inFullView(item)) {
            item.drawScrollable(poseStack, this.mc, this._mouseX, this._mouseY);
            item.renderSpecialDecoration(poseStack, this._mouseX, this._mouseY, this.getX(), this.getY(), this.getWidth(), this.f_93389_);
        } else {
            int paneBottomY = this.getY() + this.paneHeight;
            int itemBottomY = y + item.getButtonHeight();
            Integer drawY = null;
            int yDiff = 0;
            if (y < this.getY() && itemBottomY > this.getY()) {
                drawY = this.getY();
                yDiff = drawY - y;
            } else if (y < paneBottomY && itemBottomY > paneBottomY) {
                drawY = y;
                yDiff = itemBottomY - paneBottomY;
            }
            if (drawY != null && this.drawPartialScrollable) {
                item.drawPartialScrollable(poseStack, this.mc, itemX, drawY, item.getScrollableWidth(), item.getButtonHeight() - yDiff);
            }
        }
    }

    protected void m_7415_(PoseStack poseStack, int x, int y) {
        if (this.renderDecorations) {
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderWrapper.depthFunc(515);
            RenderWrapper.disableDepthTest();
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 0, 1);
            RenderWrapper.disableTexture();
            RenderWrapper.setShader(GameRenderer::m_172811_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)(this.f_93390_ + 5), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)(this.f_93390_ + 5), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)(this.f_93391_ - 5), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)(this.f_93391_ - 5), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            tesselator.m_85914_();
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.m_6702_().isEmpty()) {
            return false;
        }
        if (button == 0 && this.f_93399_) {
            if (mouseY < (double)this.f_93390_) {
                this.m_93410_(0.0);
            } else {
                double d0 = Math.max(1, this.m_93518_());
                int i = this.f_93391_ - this.f_93390_;
                int j = Mth.m_14045_((int)((int)((float)(i * i) / (float)this.m_5775_())), (int)32, (int)(i - 8));
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.m_93410_(this.m_93517_() + mouseDY * d1);
            }
            return true;
        }
        return false;
    }

    public boolean isScrollVisible() {
        return this.scrollVisible;
    }

    public boolean inFullView(Scrollable item) {
        return item.getY() >= this.getY() && item.getY() + item.getButtonHeight() <= this.getY() + this.paneHeight;
    }

    protected int m_5756_() {
        return this.paneWidth + this.getX();
    }

    protected void m_93481_(double xPos, double yPos, int button) {
        double rightX = this.getX() + this.getWidth() - 5;
        this.f_93399_ = button == 0 && xPos >= rightX && xPos < rightX + 10.0;
    }

    protected int m_5775_() {
        return super.m_5775_();
    }

    public int getWidth() {
        boolean scrollVisible = 0 < this.m_93518_();
        return this.paneWidth + (scrollVisible ? 5 : 0);
    }

    public int getFitWidth(Font fr) {
        int fit = 0;
        for (ScrollPaneEntry entry : this.m_6702_()) {
            fit = Math.max(fit, entry.item.getFitWidth(fr));
        }
        return fit;
    }

    public int m_93518_() {
        return super.m_93518_();
    }

    public boolean m_5953_(double posX, double posY) {
        int topY = this.getY();
        int bottomY = this.getY() + this.paneHeight;
        int leftX = this.getX();
        int rightX = this.getX() + this.getWidth();
        return posY >= (double)topY && posY <= (double)bottomY && posX >= (double)leftX && posX <= (double)rightX;
    }

    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        return Optional.empty();
    }

    public void m_94757_(double mouseX, double mouseY) {
        for (ScrollPaneEntry entry : super.m_6702_()) {
            Scrollable item = entry.item;
            if (item == null || !this.inFullView(item) || !(item instanceof Button)) continue;
            Button button = (Button)item;
            button.m_94757_(mouseX, mouseY);
        }
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return super.m_5534_(codePoint, modifiers);
    }

    public void m_94718_(@Nullable GuiEventListener eventListener) {
        super.m_94718_(eventListener);
    }

    public void m_94725_(@Nullable GuiEventListener eventListener) {
        super.m_94725_(eventListener);
    }

    public boolean m_5755_(boolean focus) {
        return super.m_5755_(focus);
    }

    public void setRenderSolidBackground(boolean value) {
        this.renderSolidBackground = value;
    }

    public void setRenderDecorations(boolean value) {
        this.renderDecorations = value;
    }

    class ScrollPaneEntry
    extends ObjectSelectionList.Entry<ScrollPaneEntry> {
        private ScrollPane parent;
        private Scrollable item;

        public ScrollPaneEntry(ScrollPane parent, Scrollable item) {
            this.parent = parent;
            this.item = item;
        }

        public void m_6311_(PoseStack poseStack, int index, int y, int x, int l, int var6, int var7, int p_230432_8_, boolean p_230432_9_, float f) {
            this.parent.renderItem(poseStack, index, y, x, l, var6, var7, f);
        }

        public Component m_142172_() {
            return null;
        }
    }
}

