/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.mantle.util.typed.TypedMapBuilder;

public class LoadableRecipeSerializer<T extends Recipe<?>>
implements LoggingRecipeSerializer<T> {
    public static final ContextKey<RecipeSerializer<?>> SERIALIZER = new ContextKey("serializer");
    public static final ContextKey<TypeAwareRecipeSerializer<?>> TYPED_SERIALIZER = new ContextKey("typed_serializer");
    public static final ContextKey<RecipeType<?>> TYPE = new ContextKey("type");
    public static final LoadableField<String, Recipe<?>> RECIPE_GROUP = StringLoadable.DEFAULT.defaultField("group", "", Recipe::m_6076_);
    protected final RecordLoadable<T> loadable;

    public static <T extends Recipe<?>> RecipeSerializer<T> of(RecordLoadable<T> loadable) {
        return new LoadableRecipeSerializer<T>(loadable);
    }

    public static <T extends R, R extends Recipe<?>> TypeAwareRecipeSerializer<T> of(RecordLoadable<T> loadable, Supplier<? extends RecipeType<R>> type) {
        return new TypeAware<T>(loadable, type);
    }

    protected TypedMapBuilder buildContext(ResourceLocation id) {
        return TypedMapBuilder.builder().put(ContextKey.ID, id).put(SERIALIZER, this);
    }

    public T m_6729_(ResourceLocation id, JsonObject json) {
        return (T)((Recipe)this.loadable.deserialize(json, this.buildContext(id).build()));
    }

    @Override
    public T fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
        return (T)((Recipe)this.loadable.decode(buffer, this.buildContext(id).build()));
    }

    @Override
    @Nullable
    public T m_8005_(ResourceLocation id, FriendlyByteBuf buffer) {
        try {
            return this.fromNetworkSafe(id, buffer);
        }
        catch (RuntimeException e) {
            Mantle.logger.error("{}: Error reading recipe {} from packet using loadable {}", (Object)this.getClass().getSimpleName(), (Object)id, this.loadable, (Object)e);
            throw e;
        }
    }

    @Override
    public void toNetworkSafe(FriendlyByteBuf buffer, T recipe) {
        this.loadable.encode(buffer, recipe);
    }

    protected LoadableRecipeSerializer(RecordLoadable<T> loadable) {
        this.loadable = loadable;
    }

    public static class TypeAware<T extends Recipe<?>>
    extends LoadableRecipeSerializer<T>
    implements TypeAwareRecipeSerializer<T> {
        private final Supplier<? extends RecipeType<?>> type;

        protected TypeAware(RecordLoadable<T> loadable, Supplier<? extends RecipeType<?>> type) {
            super(loadable);
            this.type = type;
        }

        @Override
        protected TypedMapBuilder buildContext(ResourceLocation id) {
            return super.buildContext(id).put(TYPE, this.getType()).put(TYPED_SERIALIZER, this);
        }

        @Override
        public RecipeType<?> getType() {
            return this.type.get();
        }

        @Override
        @Nullable
        public T m_8005_(ResourceLocation id, FriendlyByteBuf buffer) {
            try {
                return this.fromNetworkSafe(id, buffer);
            }
            catch (RuntimeException e) {
                Mantle.logger.error("{}: Error reading recipe {} of type {} from packet using loadable {}", (Object)this.getClass().getSimpleName(), (Object)id, this.getType(), (Object)this.loadable, (Object)e);
                throw e;
            }
        }
    }
}

