/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Function;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.AlwaysPresentLoadableField;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;

public record DirectRegistryField<T extends GenericLoaderRegistry.IHaveLoader, P>(Loadable<T> loadable, Function<P, T> getter) implements AlwaysPresentLoadableField<T, P>
{
    public static <N extends GenericLoaderRegistry.IHaveLoader> void serializeInto(JsonObject json, Loadable<N> loader, N value) {
        JsonElement element = loader.serialize(value);
        if (element.isJsonObject()) {
            JsonObject nestedObject = element.getAsJsonObject();
            for (Map.Entry entry : nestedObject.entrySet()) {
                json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        } else if (element.isJsonPrimitive()) {
            json.add("type", element);
        } else {
            throw new JsonIOException("Unable to serialize nested object, expected string or object");
        }
    }

    @Override
    public T get(JsonObject json) {
        return (T)((GenericLoaderRegistry.IHaveLoader)this.loadable.convert((JsonElement)json, "[unknown]"));
    }

    @Override
    public void serialize(P parent, JsonObject json) {
        DirectRegistryField.serializeInto(json, this.loadable, (GenericLoaderRegistry.IHaveLoader)this.getter.apply(parent));
    }
}

