/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.PredicateRegistry;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;

public class FallbackPredicateRegistry<T, F>
extends PredicateRegistry<T> {
    private final Function<T, F> getter;
    private final PredicateRegistry<F> fallback;
    private final RecordLoadable<FallbackPredicate> fallbackLoader;

    public FallbackPredicateRegistry(String name, IJsonPredicate<T> defaultInstance, PredicateRegistry<F> fallback, Function<T, F> getter, String fallbackName) {
        super(name, defaultInstance);
        this.fallback = fallback;
        this.getter = getter;
        this.fallbackLoader = RecordLoadable.create(fallback.directField(fallbackName + "_type", p -> p.predicate), x$0 -> new FallbackPredicate(x$0));
        this.register(Mantle.getResource(fallbackName), this.fallbackLoader);
    }

    public IJsonPredicate<T> fallback(IJsonPredicate<F> predicate) {
        return new FallbackPredicate(predicate);
    }

    @Override
    public IJsonPredicate<T> convert(JsonElement element, String key) {
        ResourceLocation type;
        JsonObject object;
        if (element.isJsonNull()) {
            return (IJsonPredicate)this.getDefault();
        }
        if (element.isJsonObject()) {
            object = element.getAsJsonObject();
            type = JsonHelper.getResourceLocation(object, "type");
        } else if (this.compact && element.isJsonPrimitive()) {
            EMPTY_OBJECT.entrySet().clear();
            object = EMPTY_OBJECT;
            type = JsonHelper.convertToResourceLocation(element, "type");
        } else {
            throw new JsonSyntaxException("Invalid " + this.getName() + " JSON at " + key + ", must be a JSON object" + (this.compact ? " or a string" : ""));
        }
        GenericLoaderRegistry.IGenericLoader loader = (GenericLoaderRegistry.IGenericLoader)this.loaders.getValue(type);
        if (loader != null) {
            return (IJsonPredicate)loader.deserialize(object);
        }
        return new FallbackPredicate((IJsonPredicate)this.fallback.convert(element, key));
    }

    @Override
    public JsonElement serialize(IJsonPredicate<T> src) {
        if (src instanceof NestedPredicate) {
            return this.fallback.serialize((F)((NestedPredicate)((Object)src)).predicate());
        }
        return super.serialize(src);
    }

    public class FallbackPredicate
    implements IJsonPredicate<T>,
    NestedPredicate<F> {
        private final IJsonPredicate<F> predicate;

        @Override
        public IJsonPredicate<F> predicate() {
            return this.predicate;
        }

        @Override
        public boolean matches(T input) {
            return this.predicate.matches(FallbackPredicateRegistry.this.getter.apply(input));
        }

        @Override
        public IJsonPredicate<T> inverted() {
            return FallbackPredicateRegistry.this.invert(this);
        }

        @Override
        public GenericLoaderRegistry.IGenericLoader<? extends IJsonPredicate<T>> getLoader() {
            return FallbackPredicateRegistry.this.fallbackLoader;
        }

        public FallbackPredicate(IJsonPredicate<F> predicate) {
            this.predicate = predicate;
        }
    }

    private static interface NestedPredicate<F> {
        public IJsonPredicate<F> predicate();
    }
}

