/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public record SimpleRecordLoadable<T>(String key, Loadable<T> loadable, boolean compact, @Nullable T defaultValue) implements RecordLoadable<T>
{
    @Override
    public T convert(JsonElement element, String key) {
        if (!element.isJsonObject()) {
            return this.loadable.convert(element, key);
        }
        return RecordLoadable.super.convert(element, key);
    }

    @Override
    public T deserialize(JsonObject json, TypedMap context) {
        if (this.defaultValue != null) {
            return this.loadable.getOrDefault(json, this.key, this.defaultValue);
        }
        return this.loadable.getIfPresent(json, this.key);
    }

    @Override
    public JsonElement serialize(T object) {
        if (this.compact) {
            return this.loadable.serialize(object);
        }
        return RecordLoadable.super.serialize(object);
    }

    @Override
    public void serialize(T object, JsonObject json) {
        json.add(this.key, this.loadable.serialize(object));
    }

    @Override
    public void encode(FriendlyByteBuf buffer, T value) {
        this.loadable.encode(buffer, value);
    }

    @Override
    public T decode(FriendlyByteBuf buffer, TypedMap context) {
        return (T)this.loadable.decode(buffer);
    }
}

