/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.common;

import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.primitive.ResourceLocationLoadable;
import slimeknights.mantle.util.RegistryHelper;

public record RegistryLoadable<T>(Registry<T> registry, ResourceLocation registryId) implements ResourceLocationLoadable<T>
{
    public RegistryLoadable(ResourceKey<? extends Registry<T>> registryId) {
        this(Objects.requireNonNull(RegistryHelper.getRegistry(registryId), "Unknown registry " + registryId.m_135782_()), registryId.m_135782_());
    }

    public RegistryLoadable(Registry<T> registry) {
        this(registry, Registry.f_122897_.m_7981_(registry));
    }

    @Override
    public T fromKey(ResourceLocation name, String key) {
        Object value;
        if (this.registry.m_7804_(name) && (value = this.registry.m_7745_(name)) != null) {
            return (T)value;
        }
        throw new JsonSyntaxException("Unable to parse " + key + " as registry " + this.registryId + " does not contain ID " + name);
    }

    @Override
    public ResourceLocation getKey(T object) {
        ResourceLocation location = this.registry.m_7981_(object);
        if (location == null) {
            throw new RuntimeException("Registry " + this.registryId + " does not contain object " + object);
        }
        return location;
    }

    @Override
    public T decode(FriendlyByteBuf buffer) {
        int id = buffer.m_130242_();
        Object value = this.registry.m_7942_(id);
        if (value == null) {
            throw new DecoderException("Registry " + this.registryId + " does not contain ID " + id);
        }
        return (T)value;
    }

    @Override
    public void encode(FriendlyByteBuf buffer, T object) {
        buffer.m_236818_(this.registry, object);
    }
}

