/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagManager;
import slimeknights.mantle.command.DumpTagCommand;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.RegistryArgument;
import slimeknights.mantle.util.JsonHelper;

public class DumpAllTagsCommand {
    private static final String TAG_DUMP_PATH = "./mantle_data_dump";

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(1))).executes(DumpAllTagsCommand::runAll)).then(Commands.m_82129_((String)"type", RegistryArgument.registry()).suggests(MantleCommand.REGISTRY).executes(DumpAllTagsCommand::runType));
    }

    protected static File getOutputFile(CommandContext<CommandSourceStack> context) {
        return ((CommandSourceStack)context.getSource()).m_81377_().m_129971_(TAG_DUMP_PATH);
    }

    protected static Component getOutputComponent(File file) {
        return Component.m_237113_((String)file.getAbsolutePath()).m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
    }

    private static int runAll(CommandContext<CommandSourceStack> context) {
        File output = DumpAllTagsCommand.getOutputFile(context);
        int tagsDumped = ((CommandSourceStack)context.getSource()).m_5894_().m_206193_().mapToInt(r -> DumpAllTagsCommand.runForFolder(context, r.f_206233_(), output)).sum();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"command.mantle.dump_all_tags.success", (Object[])new Object[]{DumpAllTagsCommand.getOutputComponent(output)}), true);
        return tagsDumped;
    }

    private static int runType(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        File output = DumpAllTagsCommand.getOutputFile(context);
        Registry<?> registry = RegistryArgument.getResult(context, "type");
        int result = DumpAllTagsCommand.runForFolder(context, registry.m_123023_(), output);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"command.mantle.dump_all_tags.type_success", (Object[])new Object[]{registry.m_123023_().m_135782_(), DumpAllTagsCommand.getOutputComponent(output)}), true);
        return result;
    }

    private static int runForFolder(CommandContext<CommandSourceStack> context, ResourceKey<? extends Registry<?>> key, File output) {
        HashMap foundTags = Maps.newHashMap();
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        ResourceManager manager = server.m_177941_();
        ResourceLocation tagType = key.m_135782_();
        String dataPackFolder = TagManager.m_203918_(key);
        for (Map.Entry entry : manager.m_214160_(dataPackFolder, fileName -> fileName.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation resourcePath = (ResourceLocation)entry.getKey();
            ResourceLocation tagId = JsonHelper.localize(resourcePath, dataPackFolder, ".json");
            DumpTagCommand.parseTag((List)entry.getValue(), foundTags.computeIfAbsent(resourcePath, id -> new ArrayList()), tagType, tagId, resourcePath);
        }
        for (Map.Entry entry : foundTags.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            Path path = output.toPath().resolve(location.m_135827_() + "/" + location.m_135815_());
            DumpTagCommand.saveTag((List)entry.getValue(), path);
        }
        return foundTags.size();
    }
}

