/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import slimeknights.mantle.client.model.util.GeometryContextWrapper;

public class ExtraTextureContext
extends GeometryContextWrapper {
    private final Map<String, Material> textures;

    public ExtraTextureContext(IGeometryBakingContext base, Map<String, Material> textures) {
        super(base);
        this.textures = textures;
    }

    public ExtraTextureContext(IGeometryBakingContext base, String name, ResourceLocation texture) {
        super(base);
        this.textures = ImmutableMap.of((Object)name, (Object)new Material(InventoryMenu.f_39692_, texture));
    }

    @Override
    public Material getMaterial(String name) {
        Material connected = this.textures.get(name);
        if (connected != null) {
            return connected;
        }
        return super.getMaterial(name);
    }

    @Override
    public boolean hasMaterial(String name) {
        return this.textures.containsKey(name) || super.hasMaterial(name);
    }
}

