/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.inventory;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.util.JsonHelper;

public class ModelItem {
    private static final ModelItem EMPTY = new ModelItem(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f);
    private final Vector3f center;
    private final float size;
    private final float x;
    private final float y;
    private final ItemTransforms.TransformType transform;
    private Vector3f centerScaled;
    private Float sizeScaled;

    public ModelItem(Vector3f center, float size, float x, float y) {
        this(center, size, x, y, ItemTransforms.TransformType.NONE);
    }

    public ModelItem(Vector3f center, float size, float x, float y, ItemTransforms.TransformType transform) {
        this.center = center;
        this.size = size;
        this.x = x;
        this.y = y;
        this.transform = transform;
    }

    public Vector3f getCenterScaled() {
        if (this.centerScaled == null) {
            this.centerScaled = this.center.m_122281_();
            this.centerScaled.m_122261_(0.0625f);
        }
        return this.centerScaled;
    }

    public float getSizeScaled() {
        if (this.sizeScaled == null) {
            this.sizeScaled = Float.valueOf(this.size / 16.0f);
        }
        return this.sizeScaled.floatValue();
    }

    public boolean isHidden() {
        return this.size == 0.0f;
    }

    private static ItemTransforms.TransformType parseTransformType(JsonObject json, String key) {
        String name = GsonHelper.m_13851_((JsonObject)json, (String)key, (String)"none");
        for (ItemTransforms.TransformType type : ItemTransforms.TransformType.values()) {
            if (!name.equals(type.getSerializeName())) continue;
            return type;
        }
        throw new JsonSyntaxException("Unknown transform type " + name);
    }

    public static ModelItem fromJson(JsonObject json) {
        float size = GsonHelper.m_13915_((JsonObject)json, (String)"size");
        if (size == 0.0f) {
            return EMPTY;
        }
        Vector3f center = ModelHelper.arrayToVector(json, "center");
        float x = ModelHelper.getRotation(json, "x");
        float y = ModelHelper.getRotation(json, "y");
        ItemTransforms.TransformType transformType = ModelItem.parseTransformType(json, "transform");
        return new ModelItem(center, size, x, y, transformType);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("size", (Number)Float.valueOf(this.size));
        if (this.size != 0.0f) {
            if (!ModelHelper.checkRotation(this.x)) {
                throw new IllegalStateException("Invalid X rotation " + this.x + ", must be 0/90/180/270");
            }
            if (!ModelHelper.checkRotation(this.y)) {
                throw new IllegalStateException("Invalid Y rotation " + this.y + ", must be 0/90/180/270");
            }
            json.add("center", (JsonElement)ModelHelper.vectorToJson(this.center));
            if (this.x != 0.0f) {
                json.addProperty("x", (Number)Float.valueOf(this.x));
            }
            if (this.y != 0.0f) {
                json.addProperty("y", (Number)Float.valueOf(this.y));
            }
            if (this.transform != ItemTransforms.TransformType.NONE) {
                json.addProperty("transform", this.transform.getSerializeName());
            }
        }
        return json;
    }

    public static List<ModelItem> listFromJson(JsonObject parent, String key) {
        return JsonHelper.parseList(parent, key, ModelItem::fromJson);
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public float getSize() {
        return this.size;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public ItemTransforms.TransformType getTransform() {
        return this.transform;
    }
}

