/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.geometry.BlockGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.client.model.util.ModelTextureIteratable;
import slimeknights.mantle.util.JsonHelper;

public class NBTKeyModel
implements IUnbakedGeometry<NBTKeyModel> {
    public static final IGeometryLoader<NBTKeyModel> LOADER = NBTKeyModel::deserialize;
    private static final Multimap<ResourceLocation, Pair<String, ResourceLocation>> EXTRA_TEXTURES = HashMultimap.create();
    private final String nbtKey;
    @Nullable
    private final ResourceLocation extraTexturesKey;
    private Map<String, Material> textures = Collections.emptyMap();

    public static void registerExtraTexture(ResourceLocation key, String textureName, ResourceLocation texture) {
        EXTRA_TEXTURES.put((Object)key, (Object)Pair.of((Object)textureName, (Object)texture));
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        this.textures = new HashMap<String, Material>();
        Material defaultTexture = owner.getMaterial("default");
        this.textures.put("default", defaultTexture);
        if (Objects.equals(defaultTexture.m_119203_(), MissingTextureAtlasSprite.m_118071_())) {
            missingTextureErrors.add((Pair<String, String>)Pair.of((Object)"default", (Object)owner.getModelName()));
        }
        if (owner instanceof BlockGeometryBakingContext) {
            BlockGeometryBakingContext blockContext = (BlockGeometryBakingContext)owner;
            ModelTextureIteratable iterable = new ModelTextureIteratable(null, blockContext.owner);
            for (Map map : iterable) {
                for (String key : map.keySet()) {
                    if (this.textures.containsKey(key) || !owner.hasMaterial(key)) continue;
                    this.textures.put(key, owner.getMaterial(key));
                }
            }
        }
        if (this.extraTexturesKey != null) {
            for (Pair extra : EXTRA_TEXTURES.get((Object)this.extraTexturesKey)) {
                String key = (String)extra.getFirst();
                if (this.textures.containsKey(key)) continue;
                this.textures.put(key, new Material(InventoryMenu.f_39692_, (ResourceLocation)extra.getSecond()));
            }
        }
        return this.textures.values();
    }

    private static BakedModel bakeModel(IGeometryBakingContext owner, Material texture, Function<Material, TextureAtlasSprite> spriteGetter, Transformation rotation, ItemOverrides overrides) {
        TextureAtlasSprite sprite = spriteGetter.apply(texture);
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)owner, (TextureAtlasSprite)sprite, (ItemOverrides)overrides, (ItemTransforms)owner.getTransforms());
        builder.addQuads(MantleItemLayerModel.getDefaultRenderType(owner), MantleItemLayerModel.getQuadsForSprite(-1, -1, sprite, rotation, 0));
        return builder.build();
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        Transformation transform = MantleItemLayerModel.applyTransform(modelTransform, owner.getRootTransform()).m_6189_();
        ImmutableMap.Builder variants = ImmutableMap.builder();
        for (Map.Entry<String, Material> entry : this.textures.entrySet()) {
            String key = entry.getKey();
            if (key.equals("default")) continue;
            variants.put((Object)key, (Object)NBTKeyModel.bakeModel(owner, entry.getValue(), spriteGetter, transform, ItemOverrides.f_111734_));
        }
        return NBTKeyModel.bakeModel(owner, this.textures.get("default"), spriteGetter, transform, new Overrides(this.nbtKey, this.textures, (Map<String, BakedModel>)variants.build()));
    }

    public static NBTKeyModel deserialize(JsonObject json, JsonDeserializationContext context) {
        String key = GsonHelper.m_13906_((JsonObject)json, (String)"nbt_key");
        ResourceLocation extraTexturesKey = null;
        if (json.has("extra_textures_key")) {
            extraTexturesKey = JsonHelper.getResourceLocation(json, "extra_textures_key");
        }
        return new NBTKeyModel(key, extraTexturesKey);
    }

    public NBTKeyModel(String nbtKey, @Nullable ResourceLocation extraTexturesKey) {
        this.nbtKey = nbtKey;
        this.extraTexturesKey = extraTexturesKey;
    }

    public static class Overrides
    extends ItemOverrides {
        private final String nbtKey;
        private final Map<String, Material> textures;
        private final Map<String, BakedModel> variants;

        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity livingEntity, int pSeed) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null && nbt.m_128441_(this.nbtKey)) {
                return this.variants.getOrDefault(nbt.m_128461_(this.nbtKey), model);
            }
            return model;
        }

        public Material getTexture(String name) {
            Material texture = this.textures.get(name);
            return texture != null ? texture : this.textures.get("default");
        }

        public Overrides(String nbtKey, Map<String, Material> textures, Map<String, BakedModel> variants) {
            this.nbtKey = nbtKey;
            this.textures = textures;
            this.variants = variants;
        }
    }
}

