/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import slimeknights.mantle.config.Config;

public class ExtraHeartRenderHandler {
    private static final ResourceLocation ICON_HEARTS = new ResourceLocation("mantle", "textures/gui/hearts.png");
    private static final ResourceLocation ICON_ABSORB = new ResourceLocation("mantle", "textures/gui/absorb.png");
    private static final ResourceLocation ICON_VANILLA = GuiComponent.f_93098_;
    private final Minecraft mc = Minecraft.m_91087_();
    private int playerHealth = 0;
    private int lastPlayerHealth = 0;
    private long healthUpdateCounter = 0L;
    private long lastSystemTime = 0L;
    private final Random rand = new Random();
    private int regen;

    private void blit(PoseStack matrixStack, int x, int y, int textureX, int textureY, int width, int height) {
        Minecraft.m_91087_().f_91065_.m_93228_(matrixStack, x, y, textureX, textureY, width, height);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderHealthbar(RenderGuiOverlayEvent.Pre event) {
        boolean highlight;
        ForgeGui gui;
        block26: {
            block25: {
                if (event.isCanceled() || !((Boolean)Config.EXTRA_HEART_RENDERER.get()).booleanValue() || event.getOverlay() != VanillaGuiOverlay.PLAYER_HEALTH.type()) {
                    return;
                }
                Gui gui2 = this.mc.f_91065_;
                if (!(gui2 instanceof ForgeGui)) break block25;
                gui = (ForgeGui)gui2;
                if (!this.mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) break block26;
            }
            return;
        }
        Entity renderViewEnity = this.mc.m_91288_();
        if (!(renderViewEnity instanceof Player)) {
            return;
        }
        Player player = (Player)renderViewEnity;
        gui.setupOverlayRenderState(true, false);
        this.mc.m_91307_().m_6180_("health");
        int left_height = gui.leftHeight;
        int width = this.mc.m_91268_().m_85445_();
        int height = this.mc.m_91268_().m_85446_();
        int updateCounter = this.mc.f_91065_.m_93079_();
        int health = Mth.m_14167_((float)player.m_21223_());
        boolean bl = highlight = this.healthUpdateCounter > (long)updateCounter && (this.healthUpdateCounter - (long)updateCounter) / 3L % 2L == 1L;
        if (health < this.playerHealth && player.f_19802_ > 0) {
            this.lastSystemTime = Util.m_137550_();
            this.healthUpdateCounter = updateCounter + 20;
        } else if (health > this.playerHealth && player.f_19802_ > 0) {
            this.lastSystemTime = Util.m_137550_();
            this.healthUpdateCounter = updateCounter + 10;
        }
        if (Util.m_137550_() - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = Util.m_137550_();
        }
        this.playerHealth = health;
        int healthLast = this.lastPlayerHealth;
        AttributeInstance attrMaxHealth = player.m_21051_(Attributes.f_22276_);
        float healthMax = attrMaxHealth == null ? 0.0f : (float)attrMaxHealth.m_22135_();
        float absorb = Mth.m_14167_((float)player.m_6103_());
        healthMax = Math.min(healthMax, 20.0f);
        health = Math.min(health, 20);
        absorb = Math.min(absorb, 20.0f);
        int healthRows = Mth.m_14167_((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.rand.setSeed((long)updateCounter * 312871L);
        int left = width / 2 - 91;
        int top = height - left_height;
        this.regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            this.regen = updateCounter % 25;
        }
        assert (this.mc.f_91073_ != null);
        int TOP = 9 * (this.mc.f_91073_.m_6106_().m_5466_() ? 5 : 0);
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        if (player.m_21023_(MobEffects.f_19614_)) {
            MARGIN += 36;
        } else if (player.m_21023_(MobEffects.f_19615_)) {
            MARGIN += 72;
        }
        float absorbRemaining = absorb;
        PoseStack matrixStack = event.getPoseStack();
        for (int i = Mth.m_14167_((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
            int row = Mth.m_14167_((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += this.rand.nextInt(2);
            }
            if (i == this.regen) {
                y -= 2;
            }
            this.blit(matrixStack, x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.blit(matrixStack, x, y, MARGIN + 54, TOP, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.blit(matrixStack, x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.blit(matrixStack, x, y, MARGIN + 153, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                this.blit(matrixStack, x, y, MARGIN + 144, TOP, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                this.blit(matrixStack, x, y, MARGIN + 36, TOP, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.blit(matrixStack, x, y, MARGIN + 45, TOP, 9, 9);
        }
        this.renderExtraHearts(matrixStack, left, top, player);
        this.renderExtraAbsorption(matrixStack, left, top - rowHeight, player);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_VANILLA);
        gui.leftHeight += 10;
        if (absorb > 0.0f) {
            gui.leftHeight += 10;
        }
        event.setCanceled(true);
        RenderSystem.m_69461_();
        this.mc.m_91307_().m_7238_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Post(event.getWindow(), matrixStack, event.getPartialTick(), VanillaGuiOverlay.PLAYER_HEALTH.type()));
    }

    private int getPotionOffset(Player player) {
        int potionOffset = 0;
        MobEffectInstance potion = player.m_21124_(MobEffects.f_19615_);
        if (potion != null) {
            potionOffset = 18;
        }
        if ((potion = player.m_21124_(MobEffects.f_19614_)) != null) {
            potionOffset = 9;
        }
        assert (this.mc.f_91073_ != null);
        if (this.mc.f_91073_.m_6106_().m_5466_()) {
            potionOffset += 27;
        }
        return potionOffset;
    }

    private void renderExtraHearts(PoseStack matrixStack, int xBasePos, int yBasePos, Player player) {
        int potionOffset = this.getPotionOffset(player);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_HEARTS);
        int hp = Mth.m_14167_((float)player.m_21223_());
        this.renderCustomHearts(matrixStack, xBasePos, yBasePos, potionOffset, hp, false);
    }

    private void renderExtraAbsorption(PoseStack matrixStack, int xBasePos, int yBasePos, Player player) {
        int potionOffset = this.getPotionOffset(player);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_ABSORB);
        int absorb = Mth.m_14167_((float)player.m_6103_());
        this.renderCustomHearts(matrixStack, xBasePos, yBasePos, potionOffset, absorb, true);
    }

    private int getYRegenOffset(int i, int offset) {
        return i + offset == this.regen ? -2 : 0;
    }

    private void renderCustomHearts(PoseStack matrixStack, int xBasePos, int yBasePos, int potionOffset, int count, boolean absorb) {
        int regenOffset = absorb ? 10 : 0;
        for (int iter = 0; iter < count / 20; ++iter) {
            int renderHearts = (count - 20 * (iter + 1)) / 2;
            int heartIndex = iter % 11;
            if (renderHearts > 10) {
                renderHearts = 10;
            }
            for (int i = 0; i < renderHearts; ++i) {
                int y = this.getYRegenOffset(i, regenOffset);
                if (absorb) {
                    this.blit(matrixStack, xBasePos + 8 * i, yBasePos + y, 0, 54, 9, 9);
                }
                this.blit(matrixStack, xBasePos + 8 * i, yBasePos + y, 18 * heartIndex, potionOffset, 9, 9);
            }
            if (count % 2 != 1 || renderHearts >= 10) continue;
            int y = this.getYRegenOffset(renderHearts, regenOffset);
            if (absorb) {
                this.blit(matrixStack, xBasePos + 8 * renderHearts, yBasePos + y, 0, 54, 9, 9);
            }
            this.blit(matrixStack, xBasePos + 8 * renderHearts, yBasePos + y, 9 + 18 * heartIndex, potionOffset, 9, 9);
        }
    }
}

