/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UpgradeItem
extends Item {
    private final Upgrade type;
    public static List<Supplier<Item>> upgrades = Arrays.asList(() -> (Item)ModItems.IRON_TIER_UPGRADE.get(), () -> (Item)ModItems.GOLD_TIER_UPGRADE.get(), () -> (Item)ModItems.DIAMOND_TIER_UPGRADE.get(), () -> (Item)ModItems.NETHERITE_TIER_UPGRADE.get());

    public UpgradeItem(Item.Properties pProperties, Upgrade type) {
        super(pProperties);
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (TravelersBackpackConfig.enableTierUpgrades) {
            switch (this.type) {
                case BLANK_UPGRADE: {
                    tooltip.add((Component)Component.m_237115_((String)"item.travelersbackpack.blank_upgrade_tooltip").m_130940_(ChatFormatting.BLUE));
                    break;
                }
                case IRON_TIER_UPGRADE: {
                    tooltip.add((Component)Component.m_237110_((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.LEATHER.getName()}).m_130940_(ChatFormatting.BLUE));
                    break;
                }
                case GOLD_TIER_UPGRADE: {
                    tooltip.add((Component)Component.m_237110_((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.IRON.getName()}).m_130940_(ChatFormatting.BLUE));
                    break;
                }
                case DIAMOND_TIER_UPGRADE: {
                    tooltip.add((Component)Component.m_237110_((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.GOLD.getName()}).m_130940_(ChatFormatting.BLUE));
                    break;
                }
                case NETHERITE_TIER_UPGRADE: {
                    tooltip.add((Component)Component.m_237110_((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.DIAMOND.getName()}).m_130940_(ChatFormatting.BLUE));
                }
            }
        } else if (this.type != Upgrade.CRAFTING_UPGRADE) {
            tooltip.add((Component)Component.m_237115_((String)"item.travelersbackpack.upgrade_disabled"));
        }
        if (this.type == Upgrade.CRAFTING_UPGRADE) {
            if (TravelersBackpackConfig.enableCraftingUpgrade) {
                tooltip.add((Component)Component.m_237115_((String)"item.travelersbackpack.crafting_upgrade_tooltip").m_130940_(ChatFormatting.BLUE));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.travelersbackpack.upgrade_disabled").m_130940_(ChatFormatting.RED));
            }
        }
    }

    public static NonNullList<ItemStack> getUpgrades(ITravelersBackpackContainer container) {
        NonNullList list = NonNullList.m_122779_();
        for (int i = 1; i <= container.getTier().getOrdinal(); ++i) {
            list.add((Object)upgrades.get(i - 1).get().m_7968_());
        }
        if (container.getSettingsManager().hasCraftingGrid()) {
            list.add((Object)((Item)ModItems.CRAFTING_UPGRADE.get()).m_7968_());
        }
        return list;
    }

    public static enum Upgrade {
        BLANK_UPGRADE,
        IRON_TIER_UPGRADE,
        GOLD_TIER_UPGRADE,
        DIAMOND_TIER_UPGRADE,
        NETHERITE_TIER_UPGRADE,
        CRAFTING_UPGRADE;

    }
}

