/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class BackpackUpgradeRecipeBuilder {
    private final Ingredient base;
    private final Ingredient addition;
    private final Item result;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private final RecipeSerializer<?> type;

    public BackpackUpgradeRecipeBuilder(RecipeSerializer<?> pType, Ingredient pBase, Ingredient pAddition, Item pResult) {
        this.type = pType;
        this.base = pBase;
        this.addition = pAddition;
        this.result = pResult;
    }

    public static BackpackUpgradeRecipeBuilder upgrade(Ingredient pBase, Ingredient pAddition, Item pResult) {
        return new BackpackUpgradeRecipeBuilder((RecipeSerializer)ModRecipeSerializers.BACKPACK_UPGRADE.get(), pBase, pAddition, pResult);
    }

    public BackpackUpgradeRecipeBuilder unlocks(String pName, CriterionTriggerInstance pCriterion) {
        this.advancement.m_138386_(pName, pCriterion);
        return this;
    }

    public void save(Consumer<FinishedRecipe> pFinishedRecipeConsumer, String pId) {
        this.save(pFinishedRecipeConsumer, new ResourceLocation(pId));
    }

    public void save(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pId) {
        this.ensureValid(pId);
        this.advancement.m_138396_(RecipeBuilder.f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pId, this.type, this.base, this.addition, this.result, this.advancement, new ResourceLocation(pId.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + pId.m_135815_())));
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pId);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient base;
        private final Ingredient addition;
        private final Item result;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<?> type;

        public Result(ResourceLocation pId, RecipeSerializer<?> pType, Ingredient pBase, Ingredient pAddition, Item pResult, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId) {
            this.id = pId;
            this.type = pType;
            this.base = pBase;
            this.addition = pAddition;
            this.result = pResult;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("base", this.base.m_43942_());
            pJson.add("addition", this.addition.m_43942_());
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", Registry.f_122827_.m_7981_((Object)this.result).toString());
            pJson.add("result", (JsonElement)jsonobject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

