/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.utils.codegen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLPaths;

public class AutomatedWikiGen {
    public static final String NEW_PAGE_STRING = "\u00a7<newPage>";

    public static void reload() {
        Path path = AutomatedWikiGen.getBasePath();
        String wiki = path.resolve("wiki").toString();
        String base = path.resolve("src/main/resources/assets/ic2/lang/wiki_en_us.json").toString();
        String backup = path.resolve("src/main/resources/assets/ic2/lang/wiki_en_us_backup.json").toString();
        AutomatedWikiGen.main("build_wiki", wiki, base, backup);
    }

    public static void main(String ... args) {
        if (args[0].equalsIgnoreCase("build_wiki")) {
            AutomatedWikiGen.backup(Paths.get(args[2], new String[0]), Paths.get(args[3], new String[0]));
            AutomatedWikiGen.buildWiki(Paths.get(args[1], new String[0]), Paths.get(args[2], new String[0]));
        } else if (args[0].equalsIgnoreCase("extract_wiki")) {
            AutomatedWikiGen.extractWiki(Paths.get(args[1], new String[0]), Paths.get(args[2], new String[0]));
        }
    }

    private static void backup(Path main, Path backup) {
        try {
            Files.copy(main, backup, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Path getBasePath() {
        return FMLPaths.GAMEDIR.get().getParent();
    }

    public static void buildWiki(Path baseFolder, Path wikiFile) {
        Object2ObjectAVLTreeMap resultMap = new Object2ObjectAVLTreeMap();
        Path path = baseFolder.getParent();
        try (Stream<Path> stream = Files.walk(baseFolder, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(arg_0 -> AutomatedWikiGen.lambda$buildWiki$1(path, (Map)resultMap, arg_0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(wikiFile, new OpenOption[0]));){
            JsonObject result = new JsonObject();
            resultMap.forEach((arg_0, arg_1) -> ((JsonObject)result).addProperty(arg_0, arg_1));
            writer.setIndent("  ");
            Streams.write((JsonElement)result, (JsonWriter)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void extractWiki(Path baseFolder, Path wikiFile) {
        try (BufferedReader reader = Files.newBufferedReader(wikiFile);){
            JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            for (Map.Entry element : obj.entrySet()) {
                String[] values = AutomatedWikiGen.filterDesc(((String)element.getKey()).split("\\."));
                Path folder = AutomatedWikiGen.createPath(baseFolder, values);
                if (Files.notExists(folder, new LinkOption[0])) {
                    Files.createDirectories(folder, new FileAttribute[0]);
                }
                try {
                    BufferedWriter writer = Files.newBufferedWriter(folder.resolve(values[values.length - 1] + ".txt"), new OpenOption[0]);
                    try {
                        for (String s : ((JsonElement)element.getValue()).getAsString().split("\n")) {
                            String[] split = s.split(NEW_PAGE_STRING);
                            if (split.length != 1) {
                                writer.write(split[0]);
                                for (int i = 1; i < split.length; ++i) {
                                    writer.newLine();
                                    writer.newLine();
                                    writer.newLine();
                                    writer.write(NEW_PAGE_STRING);
                                    writer.newLine();
                                    writer.write(split[i]);
                                }
                                writer.newLine();
                                continue;
                            }
                            writer.write(s);
                            writer.newLine();
                        }
                    }
                    finally {
                        if (writer == null) continue;
                        writer.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String buildText(Path file) {
        StringJoiner joiner = new StringJoiner("\n");
        try {
            List<String> list = Files.readAllLines(file);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                if (!list.get(i).startsWith(NEW_PAGE_STRING)) continue;
                int index = i - 1;
                while (index >= 0 && list.get(index).isEmpty()) {
                    list.remove(index--);
                    --i;
                    --m;
                }
                list.set(index, list.get(index) + list.get(i));
                list.remove(i--);
                if (i + 1 >= --m) continue;
                list.set(i, list.get(i) + list.remove(i + 1));
                --m;
            }
            for (String s : list) {
                joiner.add(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return joiner.toString();
    }

    private static String[] filterDesc(String[] array) {
        int length = array.length - 1;
        if (array[length].equals("desc")) {
            String[] result = new String[length];
            System.arraycopy(array, 0, result, 0, length);
            result[result.length - 1] = array[length - 1] + "_" + array[length];
            return result;
        }
        return array;
    }

    private static Path createPath(Path basePath, String[] array) {
        int m = array.length - 1;
        for (int i = 1; i < m; ++i) {
            basePath = basePath.resolve(array[i]);
        }
        return basePath;
    }

    private static /* synthetic */ void lambda$buildWiki$1(Path path, Map resultMap, Path T) {
        Path entry = path.relativize(T);
        resultMap.put(entry.toString().replace(File.separatorChar, '.').replace("_desc", ".desc").replace(".txt", ""), AutomatedWikiGen.buildText(T));
    }
}

