/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.compat;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.items.IItemHandlerModifiable;

public final class CuriosAPI {
    public static final String MOD_ID = "curios";
    private static final Lazy<Optional<CuriosAPI>> INSTANCE = AbstractForgeMod.singletonInstance("curios", CuriosAPI.class);
    private final Method getCuriosHelper;
    private final Method getEquippedCurios;
    private final Method findCurios;
    private final Method slotContext;
    private final Method slotStack;
    private final Method slotVisible;

    public static Optional<CuriosAPI> getInstance() {
        return (Optional)INSTANCE.get();
    }

    private CuriosAPI() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> api = Class.forName("top.theillusivec4.curios.api.CuriosApi");
        Class<?> result = Class.forName("top.theillusivec4.curios.api.SlotResult");
        Class<?> context = Class.forName("top.theillusivec4.curios.api.SlotContext");
        Class<?> helper = Class.forName("top.theillusivec4.curios.api.type.util.ICuriosHelper");
        this.getCuriosHelper = api.getMethod("getCuriosHelper", new Class[0]);
        this.getEquippedCurios = helper.getMethod("getEquippedCurios", LivingEntity.class);
        this.findCurios = helper.getMethod("findCurios", LivingEntity.class, Item.class);
        this.slotContext = result.getMethod("slotContext", new Class[0]);
        this.slotStack = result.getMethod("stack", new Class[0]);
        this.slotVisible = context.getMethod("visible", new Class[0]);
    }

    public void registerSlot(String slotType, InterModEnqueueEvent event) {
        try {
            Class<?> preset = Class.forName("top.theillusivec4.curios.api.SlotTypePreset");
            Method build = Class.forName("top.theillusivec4.curios.api.SlotTypeMessage$Builder").getMethod("build", new Class[0]);
            Object type = Enum.valueOf(preset, slotType.toUpperCase(Locale.ROOT));
            Object builder = preset.getMethod("getMessageBuilder", new Class[0]).invoke(type, new Object[0]);
            Object message = build.invoke(builder, new Object[0]);
            InterModComms.sendTo((String)MOD_ID, (String)"register_type", () -> message);
        }
        catch (Exception e) {
            ForgeEndertech.debugMsg(e.toString());
        }
    }

    public List<ItemStack> findCurios(LivingEntity entity, Item item, boolean onlyVisible) {
        try {
            Object helper = this.getCuriosHelper.invoke(null, new Object[0]);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (Object result : (List)this.findCurios.invoke(helper, entity, item)) {
                Object context;
                boolean visible;
                ItemStack stack = (ItemStack)this.slotStack.invoke(result, new Object[0]);
                if (onlyVisible && !(visible = ((Boolean)this.slotVisible.invoke(context = this.slotContext.invoke(result, new Object[0]), new Object[0])).booleanValue())) continue;
                items.add(stack);
            }
            return items;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    private Optional<IItemHandlerModifiable> getEquippedCurios(LivingEntity entity) throws InvocationTargetException, IllegalAccessException {
        Object helper = this.getCuriosHelper.invoke(null, new Object[0]);
        return ((LazyOptional)this.getEquippedCurios.invoke(helper, entity)).resolve();
    }

    public Collection<ItemStack> getAllSlots(LivingEntity entity) {
        try {
            IItemHandlerModifiable curios = this.getEquippedCurios(entity).orElse(null);
            if (curios != null) {
                ArrayList<ItemStack> slots = new ArrayList<ItemStack>();
                for (int slot = 0; slot < curios.getSlots(); ++slot) {
                    ItemStack stack = curios.getStackInSlot(slot);
                    slots.add(stack);
                }
                return slots;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }
}

