precision highp float;
uniform highp vec2 zoom;
uniform highp float u_zoom;
varying highp vec2 v_texcoord;

void main() {
	highp float z = ceil(u_zoom);
	highp vec2 coord = v_texcoord;
		    
	if( abs(mod(coord.y+coord.x, z)/zoom.x)>0.21){
		gl_FragColor = vec4(0.0,0.0,0.0,0.0);
	}else{
		gl_FragColor = vec4(0.895,0.223,0.207,1.0);
		if(abs(mod(coord.y+coord.x, z*2.0)/zoom.x)>0.21){
			gl_FragColor = gl_FragColor*max(0.0,min(1.0,2.0*(z-zoom.x)));
		}
	}
}
