precision highp float;
uniform highp sampler2D u_texture;
uniform highp vec2 zoom;
uniform highp float u_zoom;
varying highp vec2 v_texcoord;

void main() {
	highp float z = ceil(u_zoom);
	highp vec2 coord = v_texcoord;
		    
	coord = coord + 0.5*zoom;
		    
	highp float row=mod(coord.y,z*4.0);
	if(row>z*3.0){
	   coord.x = coord.x+0.5*z;
	}else if(row>z*2.0){
	   coord.x = coord.x+1.0*z;
	}else if(row>z*1.0){
	   coord.x = coord.x+1.5*z;
	}
		    
		    
	highp vec2 tex = mod(coord, z);
	tex = tex/zoom;
	if(tex.x>1.0 || tex.y>1.0){
		gl_FragColor = vec4(0.0,0.0,0.0,0.0);
	}else{
		gl_FragColor = texture2D(u_texture, tex);
		highp vec2 coordAlpha = mod(coord, z*2.0);
		coordAlpha = coordAlpha/zoom;
		if(coordAlpha.x>1.0 || coordAlpha.y>1.0){
			gl_FragColor = gl_FragColor*max(0.0,min(1.0,2.0*(z-zoom.x)));
		}
	}
}
