varying highp vec4 textureCoordinates[7];

uniform sampler2D inputImageTexture;
uniform sampler2D inputColorMap;

uniform highp float textureWidth;
uniform highp float textureHeight;

uniform highp float screenWidth;
uniform highp float screenHeight;




highp vec4 colorTemp(highp float v)
{
    return texture2D(inputColorMap, vec2(0.5, v/128.0));
}

highp float convert(highp vec4 rgb)
{
    highp float range = 120.0;
    
    highp vec2 vu = vec2(rgb.g*range - 60.0, rgb.b*range - 60.0);
    
    return length(vu);
}

mediump float value() {
    
    // texture lookup with 5x5 gauss kernel blurrrr
    
    mediump float c = 0.0;
    
    c = c + 0.02751200875 * convert(texture2D(inputImageTexture, textureCoordinates[0].rg));
    
    c = c + 0.06927956743 * convert(texture2D(inputImageTexture, textureCoordinates[1].rg));
    c = c + 0.10974622623 * convert(texture2D(inputImageTexture, textureCoordinates[2].rg));
    c = c + 0.06927956743 * convert(texture2D(inputImageTexture, textureCoordinates[3].rg));
    
    c = c + 0.02751200875 * convert(texture2D(inputImageTexture, textureCoordinates[4].rg));
    c = c + 0.10974622623 * convert(texture2D(inputImageTexture, textureCoordinates[5].rg));
    c = c + 0.17384879033 * convert(texture2D(inputImageTexture, textureCoordinates[6].rg));
    c = c + 0.10974622623 * convert(texture2D(inputImageTexture, textureCoordinates[0].ab));
    c = c + 0.02751200875 * convert(texture2D(inputImageTexture, textureCoordinates[1].ab));
    
    c = c + 0.06927956743 * convert(texture2D(inputImageTexture, textureCoordinates[2].ab));
    c = c + 0.10974622623 * convert(texture2D(inputImageTexture, textureCoordinates[3].ab));
    c = c + 0.06927956743 * convert(texture2D(inputImageTexture, textureCoordinates[4].ab));
    
    c = c + 0.02751200875 * convert(texture2D(inputImageTexture, textureCoordinates[5].ab));
    
    return c;
    
}

void main()
{
    gl_FragColor = colorTemp(value());
}
