uniform mat4 uMVPMatrix;

attribute vec4 vPosition;
attribute vec4 inputTextureCoordinate;

uniform highp float textureWidth;
uniform highp float textureHeight;

varying highp vec4 textureCoordinates[7];

void main()
{
    gl_Position = uMVPMatrix * vPosition;
    highp float dx = 1.0/textureWidth;
    highp float dy = 1.0/textureHeight;
    
    textureCoordinates[0].rg = inputTextureCoordinate.xy + vec2( 0.0*dx, -2.0*dy);
    
    textureCoordinates[1].rg = inputTextureCoordinate.xy + vec2(-1.0*dx, -1.0*dy);
    textureCoordinates[2].rg = inputTextureCoordinate.xy + vec2( 0.0*dx, -1.0*dy);
    textureCoordinates[3].rg = inputTextureCoordinate.xy + vec2( 1.0*dx, -1.0*dy);
    
    textureCoordinates[4].rg = inputTextureCoordinate.xy + vec2(-2.0*dx,  0.0*dy);
    textureCoordinates[5].rg = inputTextureCoordinate.xy + vec2(-1.0*dx,  0.0*dy);
    textureCoordinates[6].rg = inputTextureCoordinate.xy + vec2( 0.0*dx,  0.0*dy);
    textureCoordinates[0].ab = inputTextureCoordinate.xy + vec2( 1.0*dx,  0.0*dy);
    textureCoordinates[1].ab = inputTextureCoordinate.xy + vec2( 2.0*dx,  0.0*dy);
    
    textureCoordinates[2].ab = inputTextureCoordinate.xy + vec2(-1.0*dx,  1.0*dy);
    textureCoordinates[3].ab = inputTextureCoordinate.xy + vec2( 0.0*dx,  1.0*dy);
    textureCoordinates[4].ab = inputTextureCoordinate.xy + vec2( 1.0*dx,  1.0*dy);
    
    textureCoordinates[5].ab = inputTextureCoordinate.xy + vec2( 0.0*dx,  2.0*dy);
}
