varying highp vec4 textureCoordinates[7];

uniform sampler2D inputImageTexture;
uniform sampler2D inputColorMap;

uniform highp float textureWidth;
uniform highp float textureHeight;
uniform highp float zoomX;
uniform highp float zoomY;

uniform highp float screenWidth;
uniform highp float screenHeight;

highp float value(highp vec2 offset) {
    
    // texture lookup with 5x5 gauss kernel blurrrr
    
    return texture2D(inputImageTexture, textureCoordinates[6].rg+offset).b;
    
    
}

void main()
{
    highp vec2 texelSize = vec2((1.0/textureWidth)*zoomX, (1.0/textureHeight)*zoomY);
    
    lowp float result = 1.0;
    
    highp float val1 =  value(vec2(0,0));
    highp float val2 =  value(vec2(1,0)*texelSize);
    highp float val3 =  value(vec2(0,1)*texelSize);
    highp float val4 =  value(vec2(1,1)*texelSize);
    
    highp int valInt1 = int(val1 + 0.5);
    highp int valInt2 = int(val2 + 0.5);
    highp int valInt3 = int(val3 + 0.5);
    highp int valInt4 = int(val4 + 0.5);
    
    
    if(valInt1 != valInt2 || valInt1 != valInt3 || valInt1 != valInt4)
    {
        result = 0.0;
    }
    
    gl_FragColor = vec4(result,result,result,1.0);
    
}



