varying highp vec4 textureCoordinates[7];


uniform sampler2D inputImageTexture;
uniform sampler2D inputColorMap;



highp vec4 color(highp float v)
{
    highp float numberOfColors = 12.0;
    
    highp float s = float(int(255.0/numberOfColors));
    highp float t = float(int(64.0/numberOfColors));
    
    // this gives the color number
    highp int c = int(((v+s/2.0)*255.0) / s + 0.4) + 1;
    
    v = (float(c) * t + 0.5 * t) / 64.0;
    
    return texture2D(inputColorMap, vec2(0.5,v));
}

mediump float value() {
    
    // texture lookup with 5x5 gauss kernel blurrrr
    
    mediump float c = 0.0;
    
    c = c + 0.02751200875 * texture2D(inputImageTexture, textureCoordinates[0].rg).b;
    
    c = c + 0.06927956743 * texture2D(inputImageTexture, textureCoordinates[1].rg).b;
    c = c + 0.10974622623 * texture2D(inputImageTexture, textureCoordinates[2].rg).b;
    c = c + 0.06927956743 * texture2D(inputImageTexture, textureCoordinates[3].rg).b;
    
    c = c + 0.02751200875 * texture2D(inputImageTexture, textureCoordinates[4].rg).b;
    c = c + 0.10974622623 * texture2D(inputImageTexture, textureCoordinates[5].rg).b;
    c = c + 0.17384879033 * texture2D(inputImageTexture, textureCoordinates[6].rg).b;
    c = c + 0.10974622623 * texture2D(inputImageTexture, textureCoordinates[0].ab).b;
    c = c + 0.02751200875 * texture2D(inputImageTexture, textureCoordinates[1].ab).b;
    
    c = c + 0.06927956743 * texture2D(inputImageTexture, textureCoordinates[2].ab).b;
    c = c + 0.10974622623 * texture2D(inputImageTexture, textureCoordinates[3].ab).b;
    c = c + 0.06927956743 * texture2D(inputImageTexture, textureCoordinates[4].ab).b;
    
    c = c + 0.02751200875 * texture2D(inputImageTexture, textureCoordinates[5].ab).b;
    
    return c;
    
}

void main()
{
    
    
    gl_FragColor = color(value());
}


