varying highp vec4 textureCoordinates[7];

uniform sampler2D inputImageTexture;
uniform sampler2D inputColorMap;

uniform highp float textureWidth;
uniform highp float textureHeight;

uniform highp float screenWidth;
uniform highp float screenHeight;

highp vec2 convert(highp vec4 rgb)
{
    highp vec2 vu = vec2(rgb.g, rgb.b);
    
    return vu;
}

mediump vec2 value() {
    
    // texture lookup with 5x5 gauss kernel blurrrr
    
    mediump vec2 c = vec2(0.0,0.0);
    
    c = c + 0.02751200875 * convert(texture2D(inputImageTexture, textureCoordinates[0].rg));
    
    c = c + 0.06927956743 * convert(texture2D(inputImageTexture, textureCoordinates[1].rg));
    c = c + 0.10974622623 * convert(texture2D(inputImageTexture, textureCoordinates[2].rg));
    c = c + 0.06927956743 * convert(texture2D(inputImageTexture, textureCoordinates[3].rg));
    
    c = c + 0.02751200875 * convert(texture2D(inputImageTexture, textureCoordinates[4].rg));
    c = c + 0.10974622623 * convert(texture2D(inputImageTexture, textureCoordinates[5].rg));
    c = c + 0.17384879033 * convert(texture2D(inputImageTexture, textureCoordinates[6].rg));
    c = c + 0.10974622623 * convert(texture2D(inputImageTexture, textureCoordinates[0].ab));
    c = c + 0.02751200875 * convert(texture2D(inputImageTexture, textureCoordinates[1].ab));
    
    c = c + 0.06927956743 * convert(texture2D(inputImageTexture, textureCoordinates[2].ab));
    c = c + 0.10974622623 * convert(texture2D(inputImageTexture, textureCoordinates[3].ab));
    c = c + 0.06927956743 * convert(texture2D(inputImageTexture, textureCoordinates[4].ab));
    
    c = c + 0.02751200875 * convert(texture2D(inputImageTexture, textureCoordinates[5].ab));
    
    return c;
    
}

highp vec4 colorCloud(highp vec2 v)
{
    highp float darkness = 0.8;
    highp float alpha = v.x*0.9;
    return vec4((1.0-v.y*darkness)*alpha,(1.0-v.y*darkness)*alpha,(1.0-v.y*darkness)*alpha, alpha);
}

void main()
{
    
    gl_FragColor = colorCloud(value());
}
