/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class Util {
    private Util() {
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.length() == 0;
    }

    public static Map<String, String> parseTags(String tagsString) {
        if (Util.isNullOrEmpty(tagsString)) {
            return Collections.emptyMap();
        }
        String[] entries = tagsString.split(",");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String entry : entries) {
            String[] split = entry.split(":");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid tags entry: " + entry);
            }
            map.put(split[0], split[1]);
        }
        return map;
    }

    public static Set<String> parseExtraTags(String extraTagsString) {
        if (Util.isNullOrEmpty(extraTagsString)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(extraTagsString.split(",")));
    }

    public static Integer parseInteger(String value, Integer defaultValue) {
        if (Util.isNullOrEmpty(value)) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static Long parseLong(String value, Long defaultValue) {
        if (Util.isNullOrEmpty(value)) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public static Double parseDouble(String value, Double defaultValue) {
        if (Util.isNullOrEmpty(value)) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public static String trimString(String string, int maxMessageLength) {
        if (string == null) {
            return null;
        }
        if (string.length() > maxMessageLength) {
            return string.substring(0, maxMessageLength - 3) + "...";
        }
        return string;
    }
}

