/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.event.helper;

import javax.servlet.http.HttpServletRequest;
import shaded.com.getsentry.raven.event.EventBuilder;
import shaded.com.getsentry.raven.event.helper.BasicRemoteAddressResolver;
import shaded.com.getsentry.raven.event.helper.EventBuilderHelper;
import shaded.com.getsentry.raven.event.helper.RemoteAddressResolver;
import shaded.com.getsentry.raven.event.interfaces.HttpInterface;
import shaded.com.getsentry.raven.event.interfaces.UserInterface;
import shaded.com.getsentry.raven.servlet.RavenServletRequestListener;

public class HttpEventBuilderHelper
implements EventBuilderHelper {
    private final RemoteAddressResolver remoteAddressResolver;

    public HttpEventBuilderHelper() {
        this.remoteAddressResolver = new BasicRemoteAddressResolver();
    }

    public HttpEventBuilderHelper(RemoteAddressResolver remoteAddressResolver) {
        this.remoteAddressResolver = remoteAddressResolver;
    }

    @Override
    public void helpBuildingEvent(EventBuilder eventBuilder) {
        HttpServletRequest servletRequest = RavenServletRequestListener.getServletRequest();
        if (servletRequest == null) {
            return;
        }
        this.addHttpInterface(eventBuilder, servletRequest);
        this.addUserInterface(eventBuilder, servletRequest);
    }

    private void addHttpInterface(EventBuilder eventBuilder, HttpServletRequest servletRequest) {
        eventBuilder.withSentryInterface(new HttpInterface(servletRequest, this.remoteAddressResolver), false);
    }

    private void addUserInterface(EventBuilder eventBuilder, HttpServletRequest servletRequest) {
        String username = null;
        if (servletRequest.getUserPrincipal() != null) {
            username = servletRequest.getUserPrincipal().getName();
        }
        UserInterface userInterface = new UserInterface(null, username, this.remoteAddressResolver.getRemoteAddress(servletRequest), null);
        eventBuilder.withSentryInterface(userInterface, false);
    }

    public RemoteAddressResolver getRemoteAddressResolver() {
        return this.remoteAddressResolver;
    }
}

