/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.event;

import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.getsentry.raven.environment.RavenEnvironment;
import shaded.com.getsentry.raven.event.Breadcrumb;
import shaded.com.getsentry.raven.event.Event;
import shaded.com.getsentry.raven.event.interfaces.SentryInterface;

public class EventBuilder {
    public static final String DEFAULT_PLATFORM = "java";
    public static final String DEFAULT_HOSTNAME = "unavailable";
    public static final long HOSTNAME_CACHE_DURATION = TimeUnit.HOURS.toMillis(5L);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final HostnameCache HOSTNAME_CACHE = new HostnameCache(HOSTNAME_CACHE_DURATION);
    private final Event event;
    private boolean alreadyBuilt = false;

    public EventBuilder() {
        this(UUID.randomUUID());
    }

    public EventBuilder(UUID eventId) {
        this.event = new Event(eventId);
    }

    private static String calculateChecksum(String string) {
        byte[] bytes = string.getBytes(UTF_8);
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        return Long.toHexString(checksum.getValue()).toUpperCase();
    }

    private static void autoSetMissingValues(Event event) {
        if (event.getTimestamp() == null) {
            event.setTimestamp(new Date());
        }
        if (event.getPlatform() == null) {
            event.setPlatform(DEFAULT_PLATFORM);
        }
        if (event.getSdkName() == null) {
            event.setSdkName("raven-java");
        }
        if (event.getSdkVersion() == null) {
            event.setSdkVersion(RavenEnvironment.SDK_VERSION);
        }
        if (event.getServerName() == null) {
            event.setServerName(HOSTNAME_CACHE.getHostname());
        }
    }

    private static void makeImmutable(Event event) {
        event.setTags(Collections.unmodifiableMap(event.getTags()));
        event.setBreadcrumbs(Collections.unmodifiableList(event.getBreadcrumbs()));
        HashMap<String, Map<String, Object>> tempContexts = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> contextEntry : event.getContexts().entrySet()) {
            tempContexts.put(contextEntry.getKey(), Collections.unmodifiableMap(contextEntry.getValue()));
        }
        event.setContexts(Collections.unmodifiableMap(tempContexts));
        event.setExtra(Collections.unmodifiableMap(event.getExtra()));
        event.setSentryInterfaces(Collections.unmodifiableMap(event.getSentryInterfaces()));
    }

    public EventBuilder withMessage(String message) {
        this.event.setMessage(message);
        return this;
    }

    public EventBuilder withTimestamp(Date timestamp) {
        this.event.setTimestamp(timestamp);
        return this;
    }

    public EventBuilder withLevel(Event.Level level) {
        this.event.setLevel(level);
        return this;
    }

    public EventBuilder withRelease(String release) {
        this.event.setRelease(release);
        return this;
    }

    public EventBuilder withEnvironment(String environment) {
        this.event.setEnvironment(environment);
        return this;
    }

    public EventBuilder withLogger(String logger) {
        this.event.setLogger(logger);
        return this;
    }

    public EventBuilder withPlatform(String platform) {
        this.event.setPlatform(platform);
        return this;
    }

    public EventBuilder withSdkName(String sdkName) {
        this.event.setSdkName(sdkName);
        return this;
    }

    public EventBuilder withSdkVersion(String sdkVersion) {
        this.event.setSdkVersion(sdkVersion);
        return this;
    }

    public EventBuilder withCulprit(StackTraceElement frame) {
        StringBuilder sb = new StringBuilder();
        sb.append(frame.getClassName()).append(".").append(frame.getMethodName());
        if (frame.getFileName() != null && !frame.getFileName().isEmpty()) {
            sb.append("(").append(frame.getFileName());
            if (frame.getLineNumber() >= 0) {
                sb.append(":").append(frame.getLineNumber());
            }
            sb.append(")");
        }
        return this.withCulprit(sb.toString());
    }

    public EventBuilder withCulprit(String culprit) {
        this.event.setCulprit(culprit);
        return this;
    }

    public EventBuilder withTag(String tagKey, String tagValue) {
        this.event.getTags().put(tagKey, tagValue);
        return this;
    }

    public EventBuilder withBreadcrumbs(List<Breadcrumb> breadcrumbs) {
        this.event.setBreadcrumbs(breadcrumbs);
        return this;
    }

    public EventBuilder withContexts(Map<String, Map<String, Object>> contexts) {
        this.event.setContexts(contexts);
        return this;
    }

    public EventBuilder withServerName(String serverName) {
        this.event.setServerName(serverName);
        return this;
    }

    public EventBuilder withExtra(String extraName, Object extraValue) {
        this.event.getExtra().put(extraName, extraValue);
        return this;
    }

    public EventBuilder withFingerprint(String ... fingerprint) {
        ArrayList<String> list = new ArrayList<String>(fingerprint.length);
        Collections.addAll(list, fingerprint);
        this.event.setFingerprint(list);
        return this;
    }

    public EventBuilder withFingerprint(List<String> fingerprint) {
        this.event.setFingerprint(fingerprint);
        return this;
    }

    public EventBuilder withChecksumFor(String contentToChecksum) {
        return this.withChecksum(EventBuilder.calculateChecksum(contentToChecksum));
    }

    public EventBuilder withChecksum(String checksum) {
        this.event.setChecksum(checksum);
        return this;
    }

    public EventBuilder withSentryInterface(SentryInterface sentryInterface) {
        return this.withSentryInterface(sentryInterface, true);
    }

    public EventBuilder withSentryInterface(SentryInterface sentryInterface, boolean replace) {
        if (replace || !this.event.getSentryInterfaces().containsKey(sentryInterface.getInterfaceName())) {
            this.event.getSentryInterfaces().put(sentryInterface.getInterfaceName(), sentryInterface);
        }
        return this;
    }

    public synchronized Event build() {
        if (this.alreadyBuilt) {
            throw new IllegalStateException("A message can't be built twice");
        }
        EventBuilder.autoSetMissingValues(this.event);
        EventBuilder.makeImmutable(this.event);
        this.alreadyBuilt = true;
        return this.event;
    }

    public String toString() {
        return "EventBuilder{event=" + this.event + ", alreadyBuilt=" + this.alreadyBuilt + '}';
    }

    @Deprecated
    public EventBuilder setMessage(String message) {
        return this.withMessage(message);
    }

    @Deprecated
    public EventBuilder setTimestamp(Date timestamp) {
        return this.withTimestamp(timestamp);
    }

    @Deprecated
    public EventBuilder setLevel(Event.Level level) {
        return this.withLevel(level);
    }

    @Deprecated
    public EventBuilder setLogger(String logger) {
        return this.withLogger(logger);
    }

    @Deprecated
    public EventBuilder setPlatform(String platform) {
        return this.withPlatform(platform);
    }

    @Deprecated
    public EventBuilder setCulprit(StackTraceElement frame) {
        return this.withCulprit(frame);
    }

    @Deprecated
    public EventBuilder setCulprit(String culprit) {
        return this.withCulprit(culprit);
    }

    @Deprecated
    public EventBuilder addTag(String tagKey, String tagValue) {
        return this.withTag(tagKey, tagValue);
    }

    @Deprecated
    public EventBuilder setServerName(String serverName) {
        return this.withServerName(serverName);
    }

    @Deprecated
    public EventBuilder addExtra(String extraName, Object extraValue) {
        return this.withExtra(extraName, extraValue);
    }

    @Deprecated
    public EventBuilder generateChecksum(String contentToChecksum) {
        return this.withChecksumFor(contentToChecksum);
    }

    @Deprecated
    public EventBuilder setChecksum(String checksum) {
        return this.withChecksum(checksum);
    }

    @Deprecated
    public EventBuilder addSentryInterface(SentryInterface sentryInterface) {
        return this.withSentryInterface(sentryInterface);
    }

    @Deprecated
    public EventBuilder addSentryInterface(SentryInterface sentryInterface, boolean replace) {
        return this.withSentryInterface(sentryInterface, replace);
    }

    private static final class HostnameCache {
        public static final long GET_HOSTNAME_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
        private static final Logger logger = LoggerFactory.getLogger(HostnameCache.class);
        private final long cacheDuration;
        private String hostname = "unavailable";
        private long expirationTimestamp;

        private HostnameCache(long cacheDuration) {
            this.cacheDuration = cacheDuration;
        }

        public String getHostname() {
            if (this.expirationTimestamp < System.currentTimeMillis()) {
                this.updateCache();
            }
            return this.hostname;
        }

        public void updateCache() {
            FutureTask<String> futureTask = new FutureTask<String>(new HostRetriever());
            try {
                new Thread(futureTask).start();
                logger.debug("Updating the hostname cache");
                this.hostname = futureTask.get(GET_HOSTNAME_TIMEOUT, TimeUnit.MILLISECONDS);
                this.expirationTimestamp = System.currentTimeMillis() + this.cacheDuration;
            }
            catch (Exception e) {
                futureTask.cancel(true);
                this.expirationTimestamp = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(1L);
                logger.warn("Localhost hostname lookup failed, keeping the value '{}'", (Object)this.hostname, (Object)e);
            }
        }

        private static final class HostRetriever
        implements Callable<String> {
            private HostRetriever() {
            }

            @Override
            public String call() throws Exception {
                return InetAddress.getLocalHost().getCanonicalHostName();
            }
        }
    }
}

